<?php

namespace App\Http\Requests\Admin\Luckbox;

use App\Http\Requests\BaseRequest;
use App\Services\Luckbox\AwardModel;
use Illuminate\Validation\Rule;

// 拆盒机普通盒子奖品
class AwardRequest extends BaseRequest
{
    //自定义场景
    public $scene = [
        'add'  => [],
        'edit' => [],
    ];

    //验证规则
    public function rule()
    {
        return [
            'thumb'     => ['required'],
            'mark_id'   => ['required', 'integer', 'between:1,30'],
            'title'     => ['required', 'string', 'between:1,30'],
            'price'     => ['required', 'numeric', 'min:0.01'],
            'real_rate' => ['required', 'numeric', 'min:0'],
            'level'     => ['required', 'integer', Rule::in(array_keys(AwardModel::$level))],
            'type'      => ['required', 'integer', Rule::in(array_keys(AwardModel::$type))],
        ];
    }

    //验证规则
    public function message()
    {
        return [
            'thumb.required'     => '请上传赏品图',
            'mark_id.required'   => '请选择赏类型',
            'mark_id.integer'    => '赏类型选择错误',
            'mark_id.between'    => '赏类型选择不正确',
            'title.required'     => '请填写标题',
            'title.string'       => '标题填写错误',
            'title.between'      => '标题长度为1~30字符',
            'price.required'     => '请填写展示价格',
            'price.numeric'      => '展示价格填写错误',
            'price.min'          => '展示价格最小为0.01',
            'real_rate.required' => '请填写真实比例',
            'real_rate.numeric'  => '真实比例填写错误',
            'real_rate.min'      => '真实比例最小为0',
            'level.required'     => '请选择奖品等级',
            'level.integer'      => '奖品等级选择错误',
            'level.in'           => '奖品等级选择错误',
            'type.required'      => '请选择奖品类型',
            'type.integer'       => '奖品类型选择错误',
            'type.in'            => '奖品类型选择错误',
        ];
    }
}
