<?php

namespace App\Http\Requests\Admin\Admin;

use App\Http\Requests\BaseRequest;
use Illuminate\Validation\Rule;

class PermissionCreateRequest extends BaseRequest
{
    //验证规则
    public function rule()
    {
        return [
            'display_name' => ['required'],
            'name'         => ['required', 'string', 'between:1,200', Rule::unique('admin_permissions')->ignore(request()->id)],
            'route'        => ['required', 'string', 'between:1,200', Rule::unique('admin_permissions')->ignore(request()->id)],
            'sort'         => ['required', 'numeric'],
            'type'         => ['required', 'in:1,2']
        ];
    }

    //验证规则
    public function message()
    {
        return [
            'display_name.required' => '请填写显示名称',
            'name.required'         => '请填写权限名称',
            'name.string'           => '权限名称参数错误',
            'name.between'          => '权限名称为1~200个字符',
            'name.unique'           => '权限名称已存在',
            'route.required'        => '请填写路由名称',
            'route.string'          => '路由名称参数错误',
            'route.between'         => '路由名称为1~200个字符',
            'route.unique'          => '路由名称已存在',
            'sort.required'         => '请填写排序值',
            'type.required'         => '请选择类型',
            'type.in'               => '类型选择不正确',
        ];
    }
}
