<?php

namespace App\Http\Requests\Admin\Admin;

use App\Http\Requests\BaseRequest;

class ConfigurationRequest extends BaseRequest
{
    //验证规则
    public function rule()
    {
        return [
            'group_id' => 'required|integer|min:1',
            'type'     => 'required',
            'label'    => 'required|string|between:1,20',
            'key'      => 'required|string|between:1,100|unique:configuration,key',
        ];
    }

    //验证规则
    public function message()
    {
        return [
            'group_id.required' => '请选择配置组',
            'group_id.integer'  => '配置组参数错误',
            'group_id.min'      => '配置组参数错误',
            'type.required'     => '请选择类型',
            'label.required'    => '请填写配置名称',
            'label.string'      => '配置名称参数错误',
            'label.between'     => '配置名称长度为1~20',
            'key.required'      => '请填写配置字段',
            'key.string'        => '配置字段参数错误',
            'key.between'       => '配置字段长度为1~100',
            'key.unique'        => '配置字段已存在',
        ];
    }
}
