<?php

namespace App\Http\Requests\Admin\Admin;

use App\Http\Requests\BaseRequest;

class ChangePasswordRequest extends BaseRequest
{
    //验证规则
    public function rule()
    {
        return [
            'old_password' => 'required|string|between:6,14',
            'new_password' => 'required|string|between:6,14|confirmed'
        ];
    }

    //验证规则
    public function message()
    {
        return [
            'old_password.required'  => '请填写原密码',
            'old_password.string'    => '原密码参数错误',
            'old_password.between'   => '原密码为6~14个字符',
            'new_password.required'  => '请填写新密码',
            'new_password.string'    => '新密码参数错误',
            'new_password.between'   => '新密码为6~14个字符',
            'new_password.confirmed' => '两次输入密码不正确',
        ];
    }
}
