<?php

namespace App\Http\Controllers\Api\V1\User;

use Exception;
use App\ToolsClass\RedisTool;
use App\Common\Enum\RedisEnum;
use App\Common\Method\Response;
use App\Services\User\InfoModel;
use Illuminate\Support\Facades\DB;
use App\Services\User\GoldLogModel;
use App\Services\User\WithdrawModel;
use App\Http\Controllers\BaseController;
use App\Http\Requests\Api\User\WithdrawRequst;
use App\Http\Resources\User\WithdrawLogResources;

/** 提现 */
class WithdrawController extends BaseController
{
    /**
     * 申请提现
     *
     * @param  \App\Services\User\WithdrawModel      $withdrawModel
     * @param  \App\Http\Requests\Api\WithdrawRequst $validate
     * @param  \App\Services\User\UsersInfoModel     $usersInfoModel
     * @param  \App\ToolsClass\RedisTool             $redis
     * @param  \App\Services\User\GoldLogModel      $goldLogModel
     */
    public function apply(
        WithdrawModel $withdrawModel,
        WithdrawRequst $validate,
        InfoModel $infoModel,
        RedisTool $redis,
        GoldLogModel $goldLogModel
    ) {
        // 用户信息
        $user = auth('api')->user();
        $userinfo = $infoModel->where('user_id', $user->id)->first();
        // 参数验证
        if (!$validate->check($this->request->all())) {
            return $this->error($validate->getError());
        }
        $money = $this->request->money;
        $qrcode = $this->request->qrcode;
        // 加锁
        $key = RedisEnum::WITHDRAW . $user->id;
        $lock = $redis->block($key);
        if ($lock) {
            // 数据库操作
            DB::beginTransaction();
            try {
                // 提现记录添加
                $withdrawRes = $withdrawModel->withdraw($userinfo, $money, $qrcode);
                if (!$withdrawRes) {
                    return $this->unlock($redis, $key)->error(Response::getMessage());
                }
                // 用户金额变化记录事件
                $moneyLogRes = $goldLogModel->log($userinfo, -$money, $goldLogModel::TYPE_3);
                if (!$moneyLogRes) {
                    return $this->unlock($redis, $key)->error(Response::getMessage());
                }
                DB::commit();
                return $this->unlock($redis, $key)->success('提现申请成功!');
            } catch (Exception $e) {
                DB::rollBack();
                return $this->unlock($redis, $key)->error('提现申请失败!');
            }
        }
        return $this->error('操作过快!');
    }

    /**
     * 提现记录
     *
     * @param  \App\Services\User\WithdrawModel $withdrawModel
     */
    public function log(WithdrawModel $withdrawModel)
    {
        $user = auth('api')->user();
        $list = $withdrawModel->where(['user_id' => $user->id])
            ->orderByRaw('id desc')
            ->paginate($this->request->per_page ?? 20);
        $list = $withdrawModel->page($list);
        $list['data'] = WithdrawLogResources::collection($list['data']);
        return $this->success('请求成功', $list);
    }
}
