<?php

namespace App\Http\Controllers\Api\V1\User;

use Exception;
use App\Common\Method\Response;
use App\Services\User\UsersModel;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\BaseController;
use App\ToolsClass\WeChat\MiniProgramTool;

// 注册
class RegisterController extends BaseController
{
    /**
     * 小程序注册(前端把用户信息和Code传过来)POST
     *
     * @param  \App\ToolsClass\WeChat\MiniProgramTool $miniProgramTool
     * @param  \App\Services\User\UsersModel          $usersModel
     */
    public function register(
        MiniProgramTool $miniProgramTool,
        UsersModel $usersModel
    ) {
        // 用户信息 - 兼容前端传 code 或 loginCode
        $loginCode = $this->request->code ?? $this->request->loginCode;
        
        // 如果没有code，返回错误
        if (!$loginCode) {
            \Log::error('缺少登录信息');
            return $this->error('缺少登录信息!');
        }
        
        // $mobileCode = $this->request->mobileCode;
        $data = $miniProgramTool->sessionKey($loginCode);
        
        if (!$data) {
            \Log::error('微信登录失败: ' . Response::getMessage());
            return $this->error('微信登录失败: ' . Response::getMessage());
        }
        
        // $mobile = $miniProgramTool->mobile($mobileCode);
        // if (!$mobile) {
        //     return $this->error('手机号获取失败!');
        // }
        $user = $usersModel->where('openid', $data['openid'])->first();
        if ($user) {
            $token = auth('api')->login($user);
            $responseData = $usersModel->respondWithToken($user, $token);
            $responseData['is_new_user'] = false; // 老用户标识
            return $this->success('登录成功', $responseData);
        }
        
        // 新用户：获取昵称和头像（如果前端没传，使用默认值）
        $nickName = $this->request->nickName;
        $avatarUrl = $this->request->avatarUrl;
        
        // 如果前端没有传递昵称或头像，使用默认值
        if (empty($nickName)) {
            $nickName = '用户' . substr(time(), -6); // 默认昵称
        }
        
        if (empty($avatarUrl)) {
            $avatarUrl = 'https://mao.xzyzkj.cn/uploads/other/avatar3.png'; // 默认头像
        }
        
        // 注册新用户
        DB::beginTransaction();
        try {
            $parentUserId = '';
            
            // 注册（附表数据）- 处理邀请码
            if(!empty($this->request->invite_code)){
                $parentUser = $usersModel->where('invite_code',$this->request->invite_code)->first();
                if(!empty($parentUser)){
                    $parentUserId = $parentUser->id;
                }
            }
            
            $param = [
                'nickname' => $nickName,  // 使用前面处理过的变量
                'avatarurl' => $avatarUrl,  // 使用前面处理过的变量
                // 'mobile' => $mobile,
                'openid' => $data['openid'],
                'parent_id' => $parentUserId,
            ];
            
            $res = $usersModel->register($param);
            if (!$res) {
                DB::rollBack();
                \Log::error('注册失败: ' . Response::getMessage());
                return $this->error(Response::getMessage());
            }
            $user = $res;
            DB::commit();
        } catch (Exception $e) {
            \Log::error('注册异常: ' . $e->getMessage());
            DB::rollBack();
            return $this->error('注册失败: ' . $e->getMessage());
        }
        $token = auth('api')->login($user);
        $responseData = $usersModel->respondWithToken($user, $token);
        $responseData['is_new_user'] = true; // 新用户标识
        return $this->success('注册成功!', $responseData);
    }
}
