<?php

namespace App\Http\Controllers\Api\V1\User;

use App\Http\Controllers\BaseController;
use App\Http\Resources\User\MoneyResources;
use App\Services\User\CoinLogModel;
use App\Services\User\GoldLogModel;
use App\Services\User\MoneyLogModel;

class MoneyController extends BaseController
{
    /**
     * 余额明细
     *
     * @param  \App\Services\User\MoneyLogModel $model
     */
    public function money(MoneyLogModel $model)
    {
        $user = auth('api')->user();
        $per_page = $this->request->per_page ?? 20;
        $list = $model->where(['user_id' => $user->id])->orderByRaw('id desc')->paginate($per_page);
        $list = $model->page($list);
        $list['data'] = MoneyResources::collection($list['data']);
        return $this->success('请求成功', $list);
    }

    /**
     * 积分明细
     *
     * @param  \App\Services\User\CoinLogModel $model
     */
    public function coin(CoinLogModel $model)
    {
        $user = auth('api')->user();
        $per_page = $this->request->per_page ?? 20;
        $list = $model->where(['user_id' => $user->id])->orderByRaw('id desc')->paginate($per_page);
        $list = $model->page($list);
        $list['data'] = MoneyResources::collection($list['data']);
        return $this->success('请求成功', $list);
    }

    /**
     * 购物金明细
     *
     * @param  \App\Services\User\GoldLogModel $model
     */
    public function gold(GoldLogModel $model)
    {
        $user = auth('api')->user();
        $per_page = $this->request->per_page ?? 20;
        $list = $model->where(['user_id' => $user->id])->orderByRaw('id desc')->paginate($per_page);
        $list = $model->page($list);
        $list['data'] = MoneyResources::collection($list['data']);
        return $this->success('请求成功', $list);
    }
}
