<?php

namespace App\Http\Controllers\Api\V1\User;

use App\Services\User\DailiModel;
use App\Http\Controllers\BaseController;
use App\Http\Resources\User\BindResources;
use App\Common\Method\Response;
class DailiController extends BaseController
{
    /**
     * 申请代理
     *
     * @param  \App\Services\User\DailiModel $dailiModel
     */
    public function setDaili(DailiModel $dailiModel)
    {
        $dailiLog = $dailiModel->where('user_id',auth('api')->user()->id)->where('status',0)->first();
        if(!empty($dailiLog)){
            if($dailiLog->status == 1){
                return $this->error('您已经申请成功了请刷新页面或重新进入');
            }else{
                return $this->error('还在申请中，请勿重复提交');
            }
        }
        $result = $dailiModel->store(auth('api')->user(), $this->request);
        if ($result) {
            return $this->success('操作成功');
        }
        return $this->error(Response::getMessage());
    }
}
