<?php

namespace App\Http\Controllers\Api\V1\User;

use App\Common\Method\Response;
use App\Exceptions\ApiException;
use App\Services\User\AddressModel;
use App\Http\Controllers\BaseController;
use App\Http\Requests\Api\User\AddressRequest;

/** 用户地址 */
class AddressController extends BaseController
{
    /**
     * 用户地址列表
     *
     * @param  \App\Services\User\AddressModel $address
     */
    public function list(AddressModel $address)
    {
        $data = $address->list(auth('api')->user());
        return $this->success('请求成功', $data);
    }

    /**
     * 获取默认地址
     *
     * @param  \App\Services\User\AddressModel $address
     */
    public function data(AddressModel $address)
    {
        $user = auth('api')->user();
        $data = $address->where(['user_id' => $user->id, 'status' => $address::STA_1])->first();
        return $this->success('请求成功', $data);
    }

    /**
     * 地址详情
     *
     * @param  \App\Services\User\AddressModel $address
     */
    public function info(AddressModel $address)
    {
        $data = $address->where('id', $this->request->id)->first();
        if (!$data) {
            return $this->error('该地址不存在!');
        }
        return $this->success('请求成功', $data);
    }

    /**
     * 用户地址添加
     *
     * @param  \App\Services\User\AddressModel     $address
     * @param  \App\Http\Requests\Api\User\AddressRequest $validate
     */
    public function store(AddressModel $address, AddressRequest $validate)
    {
        //验证参数
        if (!$validate->check($this->request->all())) {
            throw new ApiException($validate->getError());
        }
        $result = $address->store(auth('api')->user(), $this->request);
        if ($result) {
            return $this->success('操作成功');
        }
        return $this->error(Response::getMessage());
    }

    /**
     * 设置默认地址
     * 
     * @param AddressModel $address
     * @return \Illuminate\Http\JsonResponse
     */
    public function default(AddressModel $address)
    {
        $result = $address->default(auth('api')->user(), $this->request->id);
        if ($result) {
            return $this->success('操作成功');
        }
        return $this->error(Response::getMessage());
    }

    /**
     * 地址删除
     *
     * @param  \App\Services\User\AddressModel $address
     */
    public function del(AddressModel $address)
    {
        $result = $address->del(auth('api')->user(), $this->request->id);
        if ($result) {
            return $this->success('操作成功');
        }
        return $this->error(Response::getMessage());
    }
}
