<?php

namespace App\Http\Controllers\Api\V1\Shop;

use App\Services\Shop\HotsearchModel;
use App\Http\Controllers\BaseController;

class HotsearchController extends BaseController
{
    /**
     * 商城热门搜索
     *
     * @param  \App\Services\Shop\HotsearchModel $hotsearchModel
     */
    public function list(HotsearchModel $hotsearchModel)
    {
        $list = $hotsearchModel->factor()
            ->orderByRaw('sort desc,id asc')
            ->get()
            ->pluck('title');
        return $this->success('请求成功', $list);
    }
}
