<?php

namespace App\Http\Controllers\Api\V1\Ship;

use App\Common\Method\Response;
use App\ToolsClass\AliwuliuTool;
use App\Services\Order\OrderListModel;
use App\Http\Controllers\BaseController;
use App\Http\Resources\Shop\AwardListResources;
use App\Http\Resources\Ship\ExpressInfoResources;
use App\Http\Resources\Ship\ShipLogInfoResources;

class ShopController extends BaseController
{
    /**
     * 商城订单
     *
     * @param  \App\Services\Order\OrderListModel $model
     */
    public function list(OrderListModel $model)
    {
        $user = auth('api')->user();
        // 筛选
        $where = [
            ['user_id', '=', $user->id],
            ['status', '=', $this->request->status ?? 0],
            ['type', '=', $model::TYPE_3],
        ];
        $list = $model->where($where)
            ->orderByRaw('id desc')
            ->paginate($this->request->per_page ?? 20);
        $list = $model->page($list);
        $list['data'] = AwardListResources::collection($list['data']);
        return $this->success('请求成功', $list);
    }

    /**
     * 发货详情
     *
     * @param  \App\Services\Order\OrderListModel $model
     */
    public function info(OrderListModel $model)
    {
        $user = auth('api')->user();
        $where = [
            ['id', '=', $this->request->id],
            ['user_id', '=', $user->id],
            ['type', '=', $model::TYPE_3],
        ];
        $data = $model->where($where)->first();
        if (!$data) {
            return $this->error('参数错误!');
        }
        $data = new ShipLogInfoResources($data);
        return $this->success('请求成功', $data);
    }

    /**
     * 快递详情
     *
     * @param  \App\Services\Order\OrderListModel $model
     * @param  \App\ToolsClass\AliwuliuTool       $aliwuliuTool
     */
    public function express(OrderListModel $model, AliwuliuTool $aliwuliuTool)
    {
        $user = auth('api')->user();
        $where = [
            ['id', '=', $this->request->id],
            ['user_id', '=', $user->id],
            ['type', '=', $model::TYPE_3],
        ];
        $data = $model->where(['id' => $this->request->id])
            ->where($where)
            ->whereIn('status', [$model::STA_2, $model::STA_3, $model::STA_4])
            ->first();
        if (!$data) {
            return $this->error('参数错误!');
        }
        // 快递信息
        $wuliu = $aliwuliuTool->search($data->shipinfo->express_num, $data->shipinfo->express_code, $data->shipinfo->mobile);
        if (!$wuliu) {
            return $this->error(Response::getMessage());
        }
        $data['express'] = $wuliu;
        $data = new ExpressInfoResources($data);
        return $this->success('请求成功', $data);
    }

    /**
     * 确认收货
     *
     * @param  \App\Services\Order\OrderListModel $model
     */
    public function receipt(OrderListModel $model)
    {
        $user = auth('api')->user();
        $where = [
            ['id', '=', $this->request->id],
            ['user_id', '=', $user->id],
            ['status', '=', $model::STA_2],
            ['type', '=', $model::TYPE_3],
        ];
        $data = $model->where($where)->first();
        if (!$data) {
            return $this->error('参数错误!');
        }
        $data->status = $model::STA_4;
        if (!$data->save()) {
            return $this->error('操作失败!');
        }
        return $this->success('操作成功!');
    }
}
