<?php

namespace App\Http\Controllers\Api\V1\Pay;

use App\Services\Order\OrderModel;
use App\Services\User\GoldLogModel;
use App\Services\User\BindLogModel;
use App\Services\User\UsersModel;
use Illuminate\Support\Facades\DB;
use App\ToolsClass\AliPay\AliPayTool;
use App\Http\Controllers\BaseController;
use App\Models\Admin\Configuration;
use App\Services\User\RechargeLogModel;
class AliNotifyController extends BaseController
{
    /**
     * 支付回调
     *
     * @param AliPayTool $pay
     * @param  \App\Services\Order\OrderModel    $orderModel
     */
    public function notify(
        AliPayTool $pay,
        OrderModel $orderModel,
        RechargeLogModel $rechargeLogModel
    ) {
        // 验签回调信息
        $message = $pay->app->verify();
        file_put_contents('aaa.json',json_encode($message));
        //订单不存在或者订单已支付
        $order = $orderModel->where(['order_sn' => $message['out_trade_no']])->first();
        $rechargeOrder = $rechargeLogModel->where(['out_trade_no'=>$message['out_trade_no']])->first();
        if(!empty($order)){
            if ($order->status != $orderModel::STA_0) {
                return $pay->app->success();
            }
            if ($message['trade_status'] == 'TRADE_SUCCESS') {
                // 用户支付成功
                if ($message['trade_status'] == 'TRADE_SUCCESS') {
                    // 回调
                    DB::beginTransaction();
                    try {
                        $notifyRes = $orderModel->notify($order);
                        if (!$notifyRes) {
                            // 回调失败退款
                            Db::rollBack();
                            $order->transaction_id = $message['trade_no'];    // 订单号
                            $order->status = $orderModel::STA_1;                    // 支付成功
                            $order->is_refund = $orderModel::REF_1;                 // 待退款
                            $order->save();
                        } else {
                            $order->transaction_id = $message['trade_no'];    // 订单号
                            $order->save();
                            $usersModel = new UsersModel();
                            $goldLogModel = new GoldLogModel();
                            $bindLogModel = new BindLogModel();
                            $configModel = new Configuration();
                            $user = $usersModel->where('id',$order->user_id)->first();
                            $rebateOne = $configModel->getVal('rebate_one');
                            $rebateTwo = $configModel->getVal('rebate_two');
                            $rebateThree = $configModel->getVal('rebate_three');
                            $oneUserLog = $bindLogModel->where('user_id',$order->user_id)->first();
                            if(!empty($oneUserLog)){
                                $oneUser = $usersModel->where('id',$oneUserLog['parent_id'])->first();
                                if(!empty($oneUser)){
                                    $oneMoney = $order->pay_money * ($rebateOne/100);
                                    $goldLogModel->log($oneUser->userinfo,$oneMoney,$goldLogModel::TYPE_5);
                                    $twoUserLog = $bindLogModel->where('user_id',$oneUser->id)->first();
                                }

                                if(!empty($twoUserLog)){
                                    $twoUser = $usersModel->where('id',$twoUserLog['parent_id'])->first();
                                    if(!empty($twoUser)){
                                        $twoMoney = $order->pay_money * ($rebateTwo/100);
                                        $goldLogModel->log($twoUser->userinfo,$twoMoney,$goldLogModel::TYPE_5);
                                        $threeUserLog = $bindLogModel->where('user_id',$twoUser->id)->first();
                                    }
                                    if(!empty($threeUserLog)){
                                        $threeUser = $usersModel->where('id',$threeUserLog['parent_id'])->first();
                                        if(!empty($threeUser)){
                                            $threeMoney = $order->pay_money * ($rebateThree/100);
                                            $goldLogModel->log($threeUser->userinfo,$threeMoney,$goldLogModel::TYPE_5);
                                        }


                                    }
                                }
                            }
                            DB::commit();
                        }
                        return $pay->app->success();
                    } catch (\Exception $e) {
                        Db::rollBack();
                        DB::table('test')->insert(['value' => $e]);
                    }
                }
            }
        }else{
            if ($rechargeOrder->status != $rechargeOrder::STA_0) {
                return $pay->app->success();
            }
            if($message['return_code'] == 'SUCCESS'){
                if($message['result_code'] == 'SUCCESS'){
                    DB::beginTransaction();
                    try {
                        $notifyRes = $rechargeLogModel->notify($rechargeOrder);
                        $rechargeLogModel->transaction_id = $message['transaction_id'];    // 订单号
                        $rechargeLogModel->save();
                        DB::commit();
                        return $pay->app->success();
                    } catch (\Exception $e) {
                        Db::rollBack();
                        DB::table('test')->insert(['value' => 'cz='.$e]);
                    }
                }
            }
        }
    }
}
