<?php

namespace App\Http\Controllers\Api\V1\Operate;

use App\Services\Operate\BannersModel;
use App\Http\Controllers\BaseController;
use App\Http\Resources\Operate\BannerResources;

// 帮助中心
class BannersController extends BaseController
{
    /**
     * 活动中心、轮播图列表
     *
     * @param  \App\Services\Operate\BannersModel $model
     */
    public function list(BannersModel $model)
    {
        $list = $model->factor()
            ->where('cat_id', $this->request->cat_id)
            ->orderByRaw('id desc')
            ->get();
        $list = BannerResources::collection($list);
        return $this->success('请求成功', $list);
    }

    /**
     * 轮播详情
     *
     * @param  \App\Services\Operate\BannersModel $model
     */
    public function info(BannersModel $model)
    {
        $data = $model->factor()->where('id', $this->request->id)
            ->select(['id', 'title', 'editor'])
            ->first();
        return $this->success('请求成功', $data);
    }
}
