<?php

namespace App\Http\Controllers\Api\V1\Luckbox;

use Exception;
use App\Common\Method\Response;
use Illuminate\Support\Facades\DB;
use App\Services\Luckbox\SignModel;
use App\Services\Luckbox\TermModel;
use App\Services\User\CoinLogModel;
use App\Http\Controllers\BaseController;

class SignController extends BaseController
{
    /**
     * 签到
     *
     * @param  \App\Services\Luckbox\TermModel $termModel
     * @param  \App\Services\Luckbox\SignModel $signModel
     * @param  \App\Services\User\CoinLogModel $coinLogModel
     */
    public function sign(
        TermModel $termModel,
        SignModel $signModel,
        CoinLogModel $coinLogModel
    ) {
        $user = auth('api')->user();
        // 本期数据
        $term = $termModel->getFirst($this->request->term_id);
        if (!$term) {
            return $this->error(Response::getMessage());
        }
        if ($signModel->isSign($user, $term)) {
            return $this->error('您本期已签到了!');
        }
        DB::beginTransaction();
        try {
            // 记录添加
            $log = $signModel;
            $log->user_id = $user->id;
            $log->term_id = $term->id;
            // 积分添加
            $coin = mt_rand($termModel::SING_POINTS_MIN, $termModel::SING_POINTS_MAX);
            $coinRes = $coinLogModel->log($user->userinfo, $coin, $coinLogModel::TYPE_4, '幸运盲盒第' . $term->title . '期签到');
            if (!$log->save() || !$coinRes) {
                DB::rollBack();
                return $this->error('签到失败!');
            }
            DB::commit();
            return $this->success('签到成功!');
        } catch (Exception $e) {
            DB::rollBack();
            return $this->error('操作失败!');
        }
    }
}
