<?php

namespace App\Http\Controllers\Api\V1\Luckbox;

use App\Services\Box\BoxModel;
use App\Common\Method\Response;
use Kkokk\Poster\PosterManager;
use App\Models\Admin\Configuration;
use Kkokk\Poster\Exception\Exception;
use App\Http\Controllers\BaseController;
use App\ToolsClass\WeChat\MiniProgramTool;

class ShareController extends BaseController
{
    /**
     * 生成海报
     *
     * @param  \App\Models\Admin\Configuration        $config
     * @param  \App\Services\Box\BoxModel             $boxModel
     * @param  \App\ToolsClass\WeChat\MiniProgramTool $miniProgramTool
     */
    public function poster(
        Configuration $config,
        BoxModel $boxModel,
        MiniProgramTool $miniProgramTool
    ) {
        // 盒子数据
        $box = $boxModel->getFind($this->request->id);
        if (!$box) {
            return $this->error(Response::getMessage());
        }
        $user = auth('api')->user();
        $poster = $config->getVal('app_poster'); // 海报背景图
        $scene = '1_' . $user->id . '_' . $box->id;
        $optional = [
            'page' => 'package/box/box-detail',
            'width' => 125,
            'env_version' => 'release',
            'check_path' => false,
        ];
        $qrcode = $miniProgramTool->getQrcode($scene, $optional);
        if (!$qrcode) {
            return $this->error('小程序码生成失败!');
        }
        // 字体路径
        $fonturl = public_path('PingFang Medium_downcc.otf');
        try {
            // 判断海报是否存在
            if (existsFile($poster)) {
                $name = '/uploads/trash/share_poster.png';
                $PosterManager = new PosterManager($name);
                $base64 = $PosterManager                                  // 生成的海报地址
                    ->buildImDst($poster,  515, 769)                                    // 创建画布
                    ->buildImage($user->avatar, 58, 186, 0, 0, 46, 46, false, 'circle')  // 头像
                    ->buildImage($box->thumb, 133, 300, 0, 0, 250, 250)                 // 商品图
                    ->buildImage($qrcode, 310, 583, 0, 0, 125, 125)                     // 二维码
                    ->buildText(filter_Emoji($user->nickName) . '邀请你领取', 119, 199, 20, [0, 0, 0, 1], 0, $fonturl)
                    ->buildText($box->price . '元', 129, 80, 40, [255, 242, 131, 1], 0, $fonturl)
                    ->buildText('已有' . formatNum($box->sales) . '人开启', 331, 97, 20, [238, 208, 209, 1], 0, $fonturl)
                    ->baseData();
            }
            return $this->success('请求成功', $base64);
        } catch (Exception $e) {
            return $this->error('请求失败!');
        }
    }
}
