<?php

namespace App\Http\Controllers\Api\V1\Luckbox;

use App\Services\Luckbox\TermModel;
use App\Http\Controllers\BaseController;
use App\Http\Resources\Luckbox\LogListResources;

class LogController extends BaseController
{
    /**
     * 中奖记录
     *
     * @param  \App\Services\Luckbox\JoinModel $joinModel
     * @param  \App\Services\Luckbox\TermModel $termModel
     */
    public function list(
        TermModel $termModel
    ) {
        $list = $termModel->where(['status' => $termModel::STA_1])
            ->orderByRaw('id desc')
            ->paginate($this->request->per_page ?? 20);
        $list = $termModel->page($list);
        $list['data'] = LogListResources::collection($list['data']);
        return $this->success('请求成功', $list);
    }

    /**
     * 中奖详情
     *
     * @param  \App\Services\Luckbox\JoinModel $joinModel
     * @param  \App\Services\Luckbox\TermModel $termModel
     */
    public function info(
        TermModel $termModel
    ) {
        $user = auth('api')->user();
        // 本期数据
        $term = $termModel->where('id', $this->request->term_id)->first();
        if (!$term) {
            return $this->error('请选择期数!');
        }
        $data = $termModel->info($user, $term->id);
        return $this->success('请求成功', $data);
    }
}
