<?php

namespace App\Http\Controllers\Api\V1\Luckbox;

use Exception;
use Illuminate\Support\Facades\DB;
use App\Models\Admin\Configuration;
use App\Services\Luckbox\AwardModel;
use App\Services\Order\OrderListModel;
use App\Http\Controllers\BaseController;

class HideController extends BaseController
{
    /**
     * 隐藏款领取
     *
     * @param  \App\Services\Luckbox\AwardModel   $awardModel
     * @param  \App\Services\Order\OrderListModel $orderListModel
     */
    public function receive(AwardModel $awardModel, OrderListModel $orderListModel)
    {
        $user = auth('api')->user();
        $userinfo = $user->userinfo;
        $luckbox_hiden_need = Configuration::getVal('luckbox_hiden_need') ?? 10;
        if ($userinfo->luckbox_progress < $luckbox_hiden_need) {
            return $this->error('暂不可领取!');
        }
        $award = $awardModel->factor()->where(['level' => $awardModel::LEVEL_2])->where('real_rate', '>', 0)->get();
        // 出赏
        if ($award->isEmpty()) {
            return $this->error('暂无隐藏款!');
        }
        // 比例数组
        $rate_list = array_column($award->toArray(), 'real_rate', 'id');
        // 奖品数组
        $column = [];
        foreach ($award as $v) {
            $column[$v->id] = $v;
        }
        $winning_id = luckDraw($rate_list, 100);
        $award = $column[$winning_id];
        DB::beginTransaction();
        try {
            // 奖品入库
            $res = $orderListModel->luckHideList($user, $award, $orderListModel::G_TYPE_2, $this->request->term_id);
            // 重置
            $userinfo->luckbox_progress = 0;
            if (!$res || !$userinfo->save()) {
                DB::rollBack();
                return $this->error('领取失败!');
            }
            DB::commit();
            return $this->success('领取成功');
        } catch (Exception $e) {
            DB::rollBack();
            return $this->error('操作失败!');
        }
    }
}
