<?php

namespace App\Http\Controllers\Api\V1\Luckbox;

use App\Services\Box\MarkModel;
use App\Models\Admin\Configuration;
use App\Http\Controllers\BaseController;

class ConfigController extends BaseController
{
    /**
     * 幸运盒子配置
     *
     * @param  \App\Models\Admin\Configuration $config
     */
    public function index(Configuration $config, MarkModel $markModel)
    {
        // 奖品等级比例
        $markList = $markModel->orderByRaw('sort asc')->select(['id', 'title', 'color', 'icon'])->get();
        $mark_rate = $config->getVal('luckbox_award_rate');
        $mark_rate = explode(',', $mark_rate);
        if ($markList) {
            foreach ($markList as $k => $v) {
                $v->rate = $mark_rate[$k] ?? '0.00';
            }
        }
        $data['markList'] = $markList;
        return $this->success('请求成功', $data);
    }
}
