<?php

namespace App\Http\Controllers\Api\V1\Luckbox;

use App\Services\Luckbox\AwardModel;
use App\Http\Controllers\BaseController;
use App\Http\Resources\Box\AwardListResources;

class AwardController extends BaseController
{
    /**
     * 普通奖品
     *
     * @param  \App\Models\Admin\Configuration $config
     */
    public function list(AwardModel $awardModel)
    {
        $where = [
            ['level', '=', $awardModel::LEVEL_1],
        ];
        $list = $awardModel->factor()
            ->where($where)
            ->orderByRaw('mark_id asc,id desc')
            ->paginate($this->request->per_page ?? 20);
        $list = $awardModel->page($list);
        $list['data'] = AwardListResources::collection($list['data']);
        return $this->success('请求成功', $list);
    }
}
