<?php

namespace App\Http\Controllers\Api\V1\Box;

use App\Services\Order\OrderListModel;
use App\Http\Controllers\BaseController;
use App\Http\Resources\Box\OrderLogResources;

class LogController extends BaseController
{
    /**
     * 获取抽奖的奖品
     *
     * @param  \App\Services\Order\OrderListModel $model
     */
    public function list(OrderListModel $model)
    {
        // 筛选
        $where = [
            ['type', '=', $model::TYPE_1],
            ['get_type', '=', $model::G_TYPE_1],
            //['mark_id', '=', 1],
        ];
        $list = $model->where($where)->orderByRaw('id desc')->limit(20)->get();
        $list = OrderLogResources::collection($list);
        return $this->success('请求成功', $list);
    }
}
