<?php

namespace App\Http\Controllers\Api\V1\Box;

use App\Services\Box\BoxModel;
use App\Common\Method\Response;
use App\Services\Box\AwardModel;
use App\Http\Controllers\BaseController;
use App\Http\Resources\Box\BoxInfoResources;
use App\Http\Resources\Box\BoxListResources;
use App\Http\Resources\Box\AwardListResources;
use App\Services\User\BindLogModel;
class BoxController extends BaseController
{
    /**
     * 盒子列表
     *
     * @param  \App\Services\Box\BoxModel $model
     */
    public function list(BoxModel $model)
    {
        // 筛选
        
         $bindLogModel = new BindLogModel();
        // 筛选
        $where = ['invite_switch' => 2];
        $user = auth('api')->user();

        if(!empty($this->request->invite_code) || ($user && $bindLogModel->where('user_id',$user->id)->first())){
             $where = [];
        }
        $list = $model->factor()
            ->where($where)
            ->orderByRaw('sort desc,sales desc,id desc')
            ->paginate($this->request->per_page ?? 20);
        $list = $model->page($list);
        $list['data'] = BoxListResources::collection($list['data']);
        return $this->success('请求成功', $list);
    }

    /**
     * 盒子详情
     *
     * @param  \App\Services\Box\BoxModel   $model
     * @param  \App\Services\Box\AwardModel $awardModel
     */
    public function info(BoxModel $model, AwardModel $awardModel)
    {
        // 盒子数据
        $box = $model->getFind($this->request->id);
        if (!$box) {
            return $this->error(Response::getMessage());
        }
        // 奖品数据
        $awardList = $awardModel->where(['box_id' => $box->id])
            ->orderByRaw('mark_id asc,id desc')
            ->get();
        // 组合返回数据
        $data['box'] = new BoxInfoResources($box);
        $data['awardList'] = AwardListResources::collection($awardList);
        return $this->success('请求成功', $data);
    }
}
