<?php

namespace App\Http\Controllers\Admin\Users;

use App\Services\User\UsersModel;
use App\Services\User\CoinLogModel;
use App\Services\User\MoneyLogModel;
use App\Services\User\RechargeLogModel;
use App\Services\Order\OrderModel;
use Illuminate\Support\Facades\View;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Response;
use App\Http\Requests\Admin\Users\UsersRequest;
use App\Services\User\GoldLogModel;

class DailiListController extends BaseController
{
    /** 实例 */
    protected $model;

    /** 初始化 */
    public function __construct()
    {
        parent::__construct();
        // 初始化实例
        $this->model = new UsersModel();
    }


    /** 列表 */
    public function index()
    {
        return View::make('admin.users.dailiList.index');
    }

    /** 用户数据 */
    public function data()
    {
        $orderModel = new OrderModel();
        $rechargeModel = new RechargeLogModel();
        // 筛选
        $where = [];
        // 状态筛选
        if ($this->request->id) {
            $where[] = ['id', '=', $this->request->id];
        }
        if ($this->request->nickName) {
            $where[] = ['nickName', 'like', '%' . $this->request->nickName . '%'];
        }
        if ($this->request->status) {
            $where[] = ['status', '=', $this->request->status];
        }
        $where[] = ['level', '=', 3];
        // print_r($where);
        // exit;
        // 时间筛选
        $start = $this->request->start_time;   //开始时间
        $end = $this->request->end_time;       //截至时间
        $time = [
            $start ? strtotime($start) : 0,
            $end ? strtotime($end) : time(),
        ];
        // 数据
        $res = $this->model->with(['levelinfo', 'userinfo','bindinfo'])->where($where)
            ->whereBetween('created_at', $time)
            ->orderByRaw('id desc')
            ->paginate($this->request->get('limit', 30));
        $userList = $res->toArray();
        $userIds = array_column($userList['data'],'id');
        $userOrderLog = $orderModel->whereIn('user_id',$userIds)
                        ->where('status',$orderModel::STA_1)
                        ->whereBetween('created_at', $time)
                        ->get();
        $rechargeLog = $rechargeModel->whereIn('user_id',$userIds)
                        ->where('status',$rechargeModel::STA_1)
                        ->whereBetween('created_at', $time)
                        ->get();
        foreach ($res as &$val){
            foreach ($userOrderLog as $userOrder){
                if($val['id'] == $userOrder['user_id']){
                    if(empty($val['money'])){
                        $val['money'] = 0;
                    }
                   
                    $val['money'] =  bcadd($val['money'],$userOrder['pay_money'],2);
                }
            }
            foreach ($rechargeLog as $recharge){
                if($val['id'] == $recharge['user_id']){
                    if(empty($val['recharge_money'])){
                        $val['recharge_money'] = 0;
                    }
                   
                    $val['recharge_money'] =  bcadd($val['recharge_money'],$recharge['pay_money'],2);
                }
            }
            if(empty($val['money'])){
                $val['money'] = 0;
            }
            if(empty($val['recharge_money'])){
                $val['recharge_money'] = 0;
            }
        }
        
        $data = [
            'code' => 0,
            'msg' => '正在请求中...',
            'count' => $res->total(),
            'data' => $res->items()
        ];
        return Response::json($data);
    }

    /** 添加/编辑 */
    public function store(UsersRequest $validate)
    {
        if ($this->request->isMethod('get')) {
            $model = $this->model;
            if ($this->request->id) {
                $model = $this->model->findOrFail($this->request->id);
            }
            return View::make('admin.users.users.add', compact('model'));
        }
        // 操作类型
        if ($this->request->id) {
            $scene = 'edit';
            $model = $this->model->findOrFail($this->request->id);
        } else {
            $scene = 'add';
            $model = $this->model;
        }
        //处理 状态 开关数据
        $this->request->offsetSet('status', $this->request->status ? 1 : 2);
        $this->request->offsetSet('level', $this->request->level ? 1 : 2);
        if (!$validate->scene($scene)->check($this->request->all())) {
            return $this->error($validate->getError());
        }
        try {
            $model->status = $this->request->status;
            $model->level = $this->request->level;
            $model->save();
            return $this->success('更新成功!');
        } catch (\Exception $e) {
            return $this->error('更新失败!');
        }
    }

    /**
     * 修改状态
     */
    public function show()
    {
        $model = $this->model->findOrFail($this->request->id);
        $model->status = $model->status == 2 ? 1 : 2;
        $model->save();
        return $this->success('修改成功');
    }

    /**
     * 编辑余额、积分
     *
     * @param  \App\Services\User\MoneyLogModel $moneyLogModel
     * @param  \App\Services\User\CoinLogModel  $coinLogModel
     * @param  \App\Services\User\GoldLogModel  $goldLogModel
     */
    public function edit_money(
        MoneyLogModel $moneyLogModel,
        CoinLogModel $coinLogModel,
        GoldLogModel $goldLogModel
    ) {
        // 用户信息
        $model = $this->model->findOrFail($this->request->id);
        $money_type = $this->request->money_type;
        // 编辑页面
        if ($this->request->isMethod('get')) {
            return View::make('admin.users.users.edit_money', compact('model', 'money_type'));
        }
        $user = $model;
        $money = $this->request->money;
        $type = $this->request->type;
        if ($money <= 0 || $money >= 10000000) {
            return $this->error('操作金额为1~10000000之间!');
        }
        // 余额
        if ($money_type == 1) {
            if ($type == 1) {
                $money = +$money;
                $log = $moneyLogModel->log($user->userinfo, $money, $moneyLogModel::TYPE_1);
            } else {
                if ($user->userinfo->money < $money) {
                    return $this->error('余额不足');
                }
                $money = -$money;
                $log = $moneyLogModel->log($user->userinfo, $money, $moneyLogModel::TYPE_2);
            }
        }
        // 积分
        if ($money_type == 2) {
            if ($type == 1) {
                $money = +$money;
                $log = $coinLogModel->log($user->userinfo, $money, $coinLogModel::TYPE_1);
            } else {
                if ($user->userinfo->coin < $money) {
                    return $this->error('积分不足');
                }
                $money = -$money;
                $log = $coinLogModel->log($user->userinfo, $money, $coinLogModel::TYPE_2);
            }
        }
        // 购物金
        if ($money_type == 3) {
            if ($type == 1) {
                $money = +$money;
                $log = $goldLogModel->log($user->userinfo, $money, $goldLogModel::TYPE_1);
            } else {
                if ($user->userinfo->gold < $money) {
                    return $this->error('积分不足');
                }
                $money = -$money;
                $log = $goldLogModel->log($user->userinfo, $money, $goldLogModel::TYPE_2);
            }
        }
        if (!$log) {
            return $this->error(Response::getMessage());
        }
        return $this->success('操作成功');
    }
    
    public function team()
    {
        // dd($this->request->users_id);
        return View::make('admin.users.users.index');
    }
}
