<?php

namespace App\Http\Controllers\Admin\Sys;

use View;
use App\Services\Sys\RuleModel;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Response;

class RuleController extends BaseController
{
    /** 实例 */
    protected $model;

    /** 初始化 */
    public function __construct()
    {
        parent::__construct();
        // 初始化实例
        $this->model = new RuleModel();
    }

    /** 列表 */
    public function index()
    {
        return View::make('admin.sys.rule.index');
    }

    /** 数据 */
    public function data()
    {
        // 筛选
        $where = [];
        // 数据
        $res = $this->model->where($where)
            ->paginate($this->request->get('limit', 30));
        $data = [
            'code' => 0,
            'msg' => '正在请求中...',
            'count' => $res->total(),
            'data' => $res->items(),
        ];
        return Response::json($data);
    }

    /** 添加/编辑 */
    public function store()
    {
        // 添加编辑页面
        if ($this->request->isMethod('get')) {
            $model = $this->model;
            if ($this->request->id) {
                $model = $this->model->findOrFail($this->request->id);
            }
            return View::make('admin.sys.rule.add', compact('model'));
        }
        $model = $this->model->findOrFail($this->request->id);
        try {
            $model->editor = $this->request->editor;
            $model->save();
            return $this->success('操作成功!');
        } catch (\Exception $e) {
            return $this->error('操作失败!');
        }
    }
}
