<?php

namespace App\Http\Controllers\Admin\Stats;

use Exception;
use App\Services\Order\OrderModel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\View;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Response;

class OrderController extends BaseController
{
    /** 实例 */
    protected $model;

    /** 初始化 */
    public function __construct()
    {
        parent::__construct();
        // 初始化实例
        $this->model = new OrderModel();
    }


    /** 列表 */
    public function index()
    {
        return View::make('admin.stats.order.index');
    }

    /** 用户数据 */
    public function data()
    {
        // 筛选
        $where = [
            ['status', '=', $this->model::STA_1],
        ];
        // 状态筛选
        if (isset($this->request->refund_status)) {
            $where[] = ['refund_status', '=', $this->request->refund_status];
        }
        if ($this->request->id) {
            $where[] = ['user_id', '=', $this->request->id];
        }
        if ($this->request->order_sn) {
            $where[] = ['order_sn', '=', $this->request->order_sn];
        }
        // 时间筛选
        $start = $this->request->start_time;   //开始时间
        $end = $this->request->end_time;       //截至时间
        $time = [
            $start ? strtotime($start) : 0,
            $end ? strtotime($end) : time(),
        ];
        $res = $this->model->with(['userinfo'])
            ->whereHas('userinfo', function ($query) {
                if (isset($this->request->mobile)) {
                    $query->where('mobile', $this->request->mobile);
                }
            })
            ->where($where)
            ->whereBetween('created_at', $time)
            ->orderByRaw('created_at desc')
            ->paginate($this->request->get('limit', 30));
        $data = ['code' => 0, 'msg' => '正在请求中...', 'count' => $res->total(), 'data' => $res->items()];
        return Response::json($data);
    }

    /** 退款 */
    public function refund()
    {
        $where = [
            ['id', '=', $this->request->id],
            ['status', '=', $this->model::STA_1],
            ['refund_status', '=', $this->model::REF_1],
        ];
        $order = $this->model->where($where)->first();
        if (!$order) {
            return $this->error('订单不存在或已退款!');
        }
        DB::beginTransaction();
        try {
            $result = $this->model->refund($order);
            if (!$result) {
                DB::rollBack();
                return $this->error('退款失败!');
            }
            DB::commit();
            return $this->success('退款成功');
        } catch (Exception $e) {
            DB::rollBack();
            return $this->error('操作失败!');
        }
    }
}
