<?php

namespace App\Http\Controllers\Admin\Stats;

use App\Services\User\GoldLogModel;
use Illuminate\Support\Facades\View;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Response;

class GoldController extends BaseController
{
    /** 实例 */
    protected $model;

    /** 初始化 */
    public function __construct()
    {
        parent::__construct();
        // 初始化实例
        $this->model = new GoldLogModel();
    }


    /** 列表 */
    public function index()
    {
        return View::make('admin.stats.money.gold_log');
    }

    /** 用户数据 */
    public function data()
    {
        // 筛选
        $where = [];
        // 状态筛选
        if ($this->request->id) {
            $where[] = ['user_id', '=', $this->request->id];
        }
        $status = $this->request->status;
        if ($status) {
            if ($status == 1) {
                $where[] = ['change', '>=', 0];
            }
            if ($status == 2) {
                $where[] = ['change', '<=', 0];
            }
        }
        // 时间筛选
        $start = $this->request->start_time;   //开始时间
        $end = $this->request->end_time;       //截至时间
        $time = [
            $start ? strtotime($start) : 0,
            $end ? strtotime($end) : time(),
        ];
        $res = $this->model->with(['userinfo'])
            ->whereHas('userinfo', function ($query) {
                if (isset($this->request->mobile)) {
                    $query->where('mobile', $this->request->mobile);
                }
            })
            ->where($where)
            ->whereBetween('created_at', $time)
            ->orderByRaw('id desc')
            ->paginate($this->request->get('limit', 30));
        $data = ['code' => 0, 'msg' => '正在请求中...', 'count' => $res->total(), 'data' => $res->items()];
        return Response::json($data);
    }
}
