<?php

namespace App\Http\Controllers\Admin\Stats;

use App\Services\Order\OrderModel;
use Illuminate\Support\Facades\View;
use App\Services\Order\OrderListModel;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Response;

class BoxController extends BaseController
{
    /** 实例 */
    protected $model;

    /** 初始化 */
    public function __construct()
    {
        parent::__construct();
        // 初始化实例
        $this->model = new OrderModel();
    }


    /** 列表 */
    public function index()
    {
        return View::make('admin.stats.box.box');
    }

    /** 用户数据 */
    public function data()
    {
        // 筛选
        $where = [
            ['status','=',$this->model::STA_1],
            ['refund_status','=',$this->model::REF_0],
            ['type','=',$this->model::TYPE_1],
        ];
        // 状态筛选
        if ($this->request->id) {
            $where[] = ['user_id', '=', $this->request->id];
        }
        if ($this->request->order_sn) {
            $where[] = ['order_sn', '=', $this->request->order_sn];
        }
        if ($this->request->box_id) {
            $where[] = ['data_id', '=', $this->request->box_id];
        }
        // 时间筛选
        $start = $this->request->start_time;   //开始时间
        $end = $this->request->end_time;       //截至时间
        $time = [
            $start ? strtotime($start) : 0,
            $end ? strtotime($end) : time(),
        ];
        $res = $this->model->with(['userinfo'])
            ->whereHas('userinfo',function($query){
                if (isset($this->request->mobile)) {
                    $query->where('mobile', $this->request->mobile);
                }
            })
            ->where($where)
            ->whereBetween('created_at', $time)
            ->orderByRaw('created_at desc')
            ->paginate($this->request->get('limit', 30));
        $data = ['code' => 0, 'msg' => '正在请求中...', 'count' => $res->total(), 'data' => $res->items()];
        return Response::json($data);
    }

    /** 列表 */
    public function award()
    {
        return View::make('admin.stats.box.award');
    }

    /** 用户数据 */
    public function awardData()
    {
        // 筛选
        $where = [
            ['order_id','=',$this->request->id]
        ];
        $res = OrderListModel::with('markinfo')->where($where)
            ->orderByRaw('id desc')
            ->paginate($this->request->get('limit', 30));
        $data = ['code' => 0, 'msg' => '正在请求中...', 'count' => $res->total(), 'data' => $res->items()];
        return Response::json($data);
    }
}
