<?php

namespace App\Http\Controllers\Admin\Shop;

use View;
use App\Services\Shop\CatModel;
use App\Services\Shop\ChangeModel;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Response;
use App\Http\Requests\Admin\Shop\ChangeRequest;

class ChangeController extends BaseController
{
    /** 实例 */
    protected $model;
    protected $catModel;
    protected $cat;

    /** 初始化 */
    public function __construct()
    {
        parent::__construct();
        // 初始化实例
        $this->model = new ChangeModel();
        $this->catModel = new CatModel();
        $this->cat = $this->catModel->orderByRaw('sort desc')->get();
    }

    /** 列表 */
    public function index()
    {
        // 分类数据
        $cat = $this->cat;
        return View::make('admin.shop.change.index', compact('cat'));
    }

    /** 数据 */
    public function data()
    {
        // 筛选
        $where = [];
        // 状态筛选
        if ($this->request->cat_id) {
            $where[] = ['cat_id', '=', $this->request->cat_id];
        }
        if ($this->request->status) {
            $where[] = ['status', '=', $this->request->status];
        }
        $res = $this->model->orderByRaw('sort desc,created_at desc')->where($where)
            ->paginate($this->request->get('limit', 30));
        $data = ['code' => 0, 'msg' => '正在请求中...', 'count' => $res->total(), 'data' => $res->items(),];
        return Response::json($data);
    }

    /** 添加/编辑 */
    public function store(ChangeRequest $validate)
    {
        // 添加编辑页面
        if ($this->request->isMethod('get')) {
            $model = $this->model;
            if ($this->request->id) {
                $model = $this->model->findOrFail($this->request->id);
            }
            // 分类数据
            $cat = $this->cat;
            return View::make('admin.shop.change.add', compact('model','cat'));
        }
        // 操作类型
        if ($this->request->id) {
            $scene = 'edit';
            $model = $this->model->findOrFail($this->request->id);
        } else {
            $scene = 'add';
            $model = $this->model;
        }
        if (!$validate->scene($scene)->check($this->request->all())) {
            return $this->error($validate->getError());
        }
        try {
            $model->cat_id = $this->request->cat_id;
            $model->title = $this->request->title;
            $model->thumb = $this->request->thumb;
            $model->price = $this->request->price;
            $model->sort = $this->request->sort;
            $model->editor = $this->request->editor;
            $model->status = $this->request->status ? 1 : 2;
            $model->save();
            return $this->success('操作成功!');
        } catch (\Exception $e) {
            return $this->error('操作失败!');
        }
    }

    /** 删除 */
    public function del()
    {
        $ids = $this->request->get('ids');
        if (!is_array($ids) || empty($ids)) {
            return $this->error('请选择删除项');
        }
        try {
            // 删除商品
            $this->model->destroy($ids);
            return $this->success('删除成功!');
        } catch (\Exception $e) {
            return $this->error('删除失败!');
        }
    }

    /**
     * 修改状态
     */
    public function show()
    {
        $model = $this->model->findOrFail($this->request->id);
        $model->status = $model->status == 2 ? 1 : 2;
        $model->save();
        return $this->success('修改成功');
    }
}
