<?php

namespace App\Http\Controllers\Admin\Operate;

use View;
use App\Services\Operate\RedpackModel;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Response;
use App\Http\Requests\Admin\Operate\RedpackRequest;

class RedpackController extends BaseController
{
    /** 实例 */
    protected $model;

    /** 初始化 */
    public function __construct()
    {
        parent::__construct();
        // 初始化实例
        $this->model = new RedpackModel();
    }

    /** 列表 */
    public function index()
    {
        return View::make('admin.operate.redpack.index');
    }

    /** 数据 */
    public function data()
    {
        // 筛选
        $where = [];
        // 数据
        $res = $this->model->where($where)
            ->orderByRaw('money desc')
            ->paginate($this->request->get('limit', 30));
        $data = ['code' => 0, 'msg' => '正在请求中...', 'count' => $res->total(), 'data' => $res->items()];
        return Response::json($data);
    }

    /** 添加/编辑 */
    public function store(RedpackRequest $validate)
    {
        // 添加编辑页面
        if ($this->request->isMethod('get')) {
            $model = $this->model;
            if ($this->request->id) {
                $model = $this->model->findOrFail($this->request->id);
            }
            return View::make('admin.operate.redpack.add', compact('model'));
        }
        // 添加编辑操作
        if ($this->request->id) {
            $scene = 'edit';
            $model = $this->model->findOrFail($this->request->id);
        } else {
            $scene = 'add';
            $model = $this->model;
        }
        if (!$validate->scene($scene)->check($this->request->all())) {
            return $this->error($validate->getError());
        }
        try {
            $model->money = $this->request->money;
            // 是否重置概率判断
            $reset = false;
            if (($scene == 'edit' && $model->real_rate != $this->request->real_rate) || $scene == 'add') {
                $reset = true;
            }
            $model->real_rate = $this->request->real_rate;
            $model->save();
            // 重置概率（添加奖品或者修改概率）
            if ($reset) {
                $this->model->reset($model->box_id);
            }
            return $this->success('操作成功!');
        } catch (\Exception $e) {
            return $this->error('操作失败!');
        }
    }

    /** 删除 */
    public function del()
    {
        $ids = $this->request->get('ids');
        if (!is_array($ids) || empty($ids)) {
            return $this->error('请选择删除项');
        }
        try {
            $this->model->destroy($ids);
            return $this->success('删除成功!');
        } catch (\Exception $e) {
            return $this->error('删除失败!');
        }
    }
}
