<?php

namespace App\Http\Controllers\Admin\Operate;

use View;
use App\Services\Operate\BannersModel;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Response;
use App\Http\Requests\Admin\Operate\BannersRequest;

/** 轮播图 */
class BannersController extends BaseController
{
    /** 实例 */
    protected $model;

    /** 初始化 */
    public function __construct()
    {
        parent::__construct();
        // 初始化实例
        $this->model = new BannersModel();
    }

    /** 列表 */
    public function index()
    {
        // 分类数据
        $cat = $this->model::$cat;
        return View::make('admin.operate.banners.index', compact('cat'));
    }

    /** 数据 */
    public function data()
    {
        // 筛选
        $where = [];
        if ($this->request->cat_id) {
            $where[] = ['cat_id', '=', $this->request->cat_id];
        }
        if ($this->request->status) {
            $where[] = ['status', '=', $this->request->status];
        }
        // 数据
        $cat = $this->model::$cat;
        $url_type = $this->model::$url_type;
        $res = $this->model->where($where)
            ->orderByRaw('id desc')
            ->paginate($this->request->get('limit', 30));
        // 字段编辑
        if (!$res->isEmpty()) {
            foreach ($res as $v) {
                $v->cat_desc = $cat[$v->cat_id] ?? '';
                $v->url_type_desc = $url_type[$v->url_type] ?? '';
            }
        }
        $data = ['code' => 0, 'msg' => '正在请求中...', 'count' => $res->total(), 'data' => $res->items()];
        return Response::json($data);
    }

    /** 添加/编辑 */
    public function store(BannersRequest $validate)
    {
        // 添加编辑页面
        if ($this->request->isMethod('get')) {
            $model = $this->model;
            if ($this->request->id) {
                $model = $this->model->findOrFail($this->request->id);
            }
            $cat = $this->model::$cat;
            $url_type = $this->model::$url_type;
            return View::make('admin.operate.banners.add', compact('model', 'cat', 'url_type'));
        }
        // 添加编辑操作
        if ($this->request->id) {
            $scene = 'edit';
            $model = $this->model->findOrFail($this->request->id);
        } else {
            $scene = 'add';
            $model = $this->model;
        }
        if (!$validate->scene($scene)->check($this->request->all())) {
            return $this->error($validate->getError());
        }
        try {
            $model->cat_id = $this->request->cat_id;
            $model->title = $this->request->title;
            $model->thumb = $this->request->thumb[0];
            $model->editor = $this->request->editor;
            $model->url_type = $this->request->url_type;
            $model->status = $this->request->status ? 1 : 2;
            $model->links = $this->request->links;
            $model->save();
            return $this->success('操作成功!');
        } catch (\Exception $e) {
            return $this->error('操作失败!');
        }
    }

    /** 删除 */
    public function del()
    {
        $ids = $this->request->get('ids');
        if (!is_array($ids) || empty($ids)) {
            return $this->error('请选择删除项');
        }
        try {
            $this->model->destroy($ids);
            return $this->success('删除成功!');
        } catch (\Exception $e) {
            return $this->error('删除失败!');
        }
    }

    /**
     * 修改状态
     */
    public function show()
    {
        $model = $this->model->findOrFail($this->request->id);
        $model->status = $model->status == 2 ? 1 : 2;
        $model->save();
        return $this->success('修改成功');
    }
}
