<?php

namespace App\Http\Controllers\Admin\Complain;

use View;
use App\Services\Complain\TypeModel;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Response;
use App\Http\Requests\Admin\Complain\TypeRequest;

class TypeController extends BaseController
{
    /** 实例 */
    protected $model;

    /** 初始化 */
    public function __construct()
    {
        parent::__construct();
        // 初始化实例
        $this->model = new TypeModel();
    }

    /** 列表 */
    public function index()
    {
        return View::make('admin.complain.type.index');
    }

    /** 数据 */
    public function data()
    {
        $res = $this->model->orderByRaw('sort desc')->get();
        $data = [
            'code' => 0,
            'msg' => '正在请求中...',
            'count' => $res->count(),
            'data' => $res,
        ];
        return Response::json($data);
    }

    /** 添加/编辑 */
    public function store(TypeRequest $validate)
    {
        // 添加编辑页面
        if ($this->request->isMethod('get')) {
            $model = $this->model;
            if ($this->request->id) {
                $model = $this->model->findOrFail($this->request->id);
            }
            return View::make('admin.complain.type.add', compact('model'));
        }
        // 操作类型
        if ($this->request->id) {
            $scene = 'edit';
            $model = $this->model->findOrFail($this->request->id);
        } else {
            $scene = 'add';
            $model = $this->model;
        }
        if (!$validate->scene($scene)->check($this->request->all())) {
            return $this->error($validate->getError());
        }
        try {
            $model->title = $this->request->title;
            $model->sort = $this->request->sort;
            $model->save();
            return $this->success('操作成功!');
        } catch (\Exception $e) {
            return $this->error('操作失败!');
        }
    }

    /** 删除 */
    public function del()
    {
        $ids = $this->request->get('ids');
        if (!is_array($ids) || empty($ids)) {
            return $this->error('请选择删除项');
        }
        $data = $this->model->whereIn('parent_id', $ids)->get();
        if (!$data->isEmpty()) {
            return $this->error('该分类下有分类,请先删除!');
        }
        try {
            $this->model->destroy($ids);
            return $this->success('删除成功!');
        } catch (\Exception $e) {
            return $this->error('删除失败!');
        }
    }
}
