<?php

namespace App\Http\Controllers\Admin\Complain;

use View;
use App\Http\Controllers\BaseController;
use App\Services\Complain\ComplainModel;
use Illuminate\Support\Facades\Response;

class ComplainController extends BaseController
{
    /** 实例 */
    protected $model;

    /** 初始化 */
    public function __construct()
    {
        parent::__construct();
        // 初始化实例
        $this->model = new ComplainModel();
    }

    /** 列表 */
    public function index()
    {
        return View::make('admin.complain.complain.index');
    }

    /** 数据 */
    public function data()
    {
        // 筛选
        $where = [];
        // 状态筛选
        if (isset($this->request->status)) {
            $where[] = ['status', '=', $this->request->status];
        }
        $res = $this->model->where($where)->orderByRaw('id desc')->paginate($this->request->get('limit', 30));
        $data = ['code' => 0, 'msg' => '正在请求中...', 'count' => $res->total(), 'data' => $res->items()];
        return Response::json($data);
    }

    /** 添加/编辑 */
    public function reply()
    {
        // 添加编辑页面
        if ($this->request->isMethod('get')) {
            $model = $this->model;
            if ($this->request->id) {
                $model = $this->model->findOrFail($this->request->id);
            }
            return View::make('admin.complain.complain.add', compact('model'));
        }
        $model = $this->model->findOrFail($this->request->id);
        if (!$this->request->reply) {
            return $this->error('请填写回复内容');
        }
        try {
            $model->reply = $this->request->reply;
            $model->status = 1;
            $model->save();
            return $this->success('操作成功!');
        } catch (\Exception $e) {
            return $this->error('操作失败!');
        }
    }
}
