<?php

namespace App\Http\Controllers\Admin\Box;

use View;
use App\Services\Order\OrderListModel;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Response;

class LogController extends BaseController
{
    /** 实例 */
    protected $model;

    /** 初始化 */
    public function __construct()
    {
        parent::__construct();
        // 初始化实例
        $this->model = new OrderListModel();
    }

    /** 列表 */
    public function index()
    {
        return View::make('admin.box.log.index');
    }

    /** 数据 */
    public function data()
    {
        // 筛选
        $where = [
            ['data_id', '=', $this->request->box_id],
            ['type', '=', $this->model::TYPE_1],
        ];
        $res = $this->model->where($where)->with(['markinfo','userinfo'])->orderByRaw('id desc')->paginate($this->request->get('limit', 30));
        $data = ['code' => 0, 'msg' => '正在请求中...', 'count' => $res->total(), 'data' => $res->items()];
        return Response::json($data);
    }
}
