<?php

namespace App\Http\Controllers\Admin\Box;

use View;
use App\Services\Box\DrawModel;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Response;
use App\Http\Requests\Admin\Box\DrawRequest;

// 抽取方式
class DrawController extends BaseController
{
    /** 实例 */
    protected $model;

    /** 初始化 */
    public function __construct()
    {
        parent::__construct();
        // 初始化实例
        $this->model = new DrawModel();
    }

    /** 列表 */
    public function index()
    {
        return View::make('admin.box.draw.index');
    }

    /** 数据 */
    public function data()
    {
        // 筛选
        $where = [];
        $res = $this->model->where($where)->orderByRaw('sort asc,id asc')->paginate($this->request->get('limit', 30));
        $data = ['code' => 0, 'msg' => '正在请求中...', 'count' => $res->total(), 'data' => $res->items()];
        return Response::json($data);
    }

    /** 添加/编辑 */
    public function store(DrawRequest $validate)
    {
        // 添加编辑页面
        if ($this->request->isMethod('get')) {
            $model = $this->model;
            if ($this->request->id) {
                $model = $this->model->findOrFail($this->request->id);
            }
            return View::make('admin.box.draw.add', compact('model'));
        }
        // 添加编辑操作
        if ($this->request->id) {
            $scene = 'edit';
            $model = $this->model->findOrFail($this->request->id);
        } else {
            $scene = 'add';
            $model = $this->model;
        }
        if (!$validate->scene($scene)->check($this->request->all())) {
            return $this->error($validate->getError());
        }
        try {
            $model->title = $this->request->title;
            // $model->times = $this->request->times;
            $model->save();
            return $this->success('操作成功!');
        } catch (\Exception $e) {
            return $this->error('操作失败!');
        }
    }

    /**
     * 修改状态
     */
    public function show()
    {
        $model = $this->model->findOrFail($this->request->id);
        $model->status = $model->status == 2 ? 1 : 2;
        $model->save();
        return $this->success('修改成功');
    }
}
