<?php

namespace App\Http\Controllers\Admin\Box;

use View;
use App\Services\Box\MarkModel;
use App\Services\Box\AwardModel;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Response;
use App\Http\Requests\Admin\Box\AwardRequest;

// 盒子
class AwardController extends BaseController
{
    /** 实例 */
    protected $model;
    protected $markModel;
    protected $mark;

    /** 初始化 */
    public function __construct()
    {
        parent::__construct();
        // 初始化实例
        $this->model = new AwardModel();
        $this->markModel = new MarkModel();
        $this->mark = $this->markModel->orderByRaw('sort asc,id asc')->get();
    }

    /** 列表 */
    public function index()
    {
        return View::make('admin.box.award.index');
    }

    /** 数据 */
    public function data()
    {
        // 筛选
        $where[] = ['box_id', '=', $this->request->box_id];
        if ($this->request->title) {
            $where[] = ['title', 'like', '%' . $this->request->title . '%'];
        }
        $res = $this->model->with('markinfo')->where($where)->orderByRaw('mark_id asc,id desc')->paginate($this->request->get('limit', 30));
        $data = ['code' => 0, 'msg' => '正在请求中...', 'count' => $res->total(), 'data' => $res->items()];
        return Response::json($data);
    }

    /** 添加/编辑 */
    public function store(AwardRequest $validate)
    {
        // 添加编辑页面
        if ($this->request->isMethod('get')) {
            $model = $this->model;
            if ($this->request->id) {
                $model = $this->model->findOrFail($this->request->id);
            }
            // 赏类型
            $mark = $this->mark;
            return View::make('admin.box.award.add', compact('model', 'mark'));
        }
        // 添加编辑操作
        if ($this->request->id) {
            $scene = 'edit';
            $model = $this->model->findOrFail($this->request->id);
        } else {
            $scene = 'add';
            $model = $this->model;
            $model->box_id = $this->request->box_id;
        }
        if (!$validate->scene($scene)->check($this->request->all())) {
            return $this->error($validate->getError());
        }
        try {
            $model->thumb = $this->request->thumb[0];
            $model->mark_id = $this->request->mark_id;
            $model->title = $this->request->title;
            $model->price = $this->request->price;
            // 是否重置概率判断
            $reset = false;
            if (($scene == 'edit' && $model->real_rate != $this->request->real_rate) || $scene == 'add') {
                $reset = true;
            }
            $model->show_rate = $this->request->show_rate;
            $model->real_rate = $this->request->real_rate;
            $model->anchor_rate = $this->request->anchor_rate;
            $model->dissolve_rate = $this->request->dissolve_rate;
            $model->editor = $this->request->editor;
            $model->save();
            // 重置概率（添加奖品或者修改概率）
            if ($reset) {
                $this->model->reset($model->box_id);
            }
            return $this->success('操作成功!');
        } catch (\Exception $e) {
            return $this->error('操作失败!');
        }
    }

    /** 删除 */
    public function del()
    {
        $ids = $this->request->get('ids');
        if (!is_array($ids) || empty($ids)) {
            return $this->error('请选择删除项');
        }
        try {
            $this->model->destroy($ids);
            return $this->success('删除成功!');
        } catch (\Exception $e) {
            return $this->error('删除失败!');
        }
    }
}
