<?php

namespace App\Http\Controllers\Admin\Admin;

use App\ToolsClass\TimeTool;
use App\Services\User\UsersModel;
use Illuminate\Support\Facades\View;
use App\Http\Controllers\BaseController;
use App\Services\Order\OrderModel;
use App\Services\User\MoneyLogModel;
use App\Services\User\RechargeLogModel;
use App\Services\User\WithdrawModel;

class IndexController extends BaseController
{
    //后台首页
    public function layout()
    {
        //左侧菜单
        view()->composer('admin.layout', function ($view) {
            $menus = \App\Models\Admin\Permission::with(['childs'])->orderByRaw('sort asc')->where('parent_id', 0)->get();
            $view->with('menus', $menus);
        });
        return View::make('admin.layout');
    }

    /**
     * 后台主页
     *
     * @param  \App\Services\User\UsersModel $usersModel
     * @param  \App\ToolsClass\TimeTool      $timeTool
     */
    public function index(UsersModel $usersModel, TimeTool $timeTool, OrderModel $orderModel, MoneyLogModel $moneyLogModel, RechargeLogModel $rechargeLogModel)
    {
        // 用户量
        $data['user_day'] = $usersModel->whereBetween('created_at', $timeTool->day())->count();
        $data['user_month'] = $usersModel->whereBetween('created_at', $timeTool->month())->count();
        $data['user_total'] = $usersModel->count();
        // 订单
        $data['order_day'] = $orderModel->whereBetween('created_at', $timeTool->day())->count();
        $data['order_month'] = $orderModel->whereBetween('created_at', $timeTool->month())->count();
        $data['order_total'] = $orderModel->count();
        $data['day_money'] = $orderModel->whereBetween('created_at', $timeTool->day())->where('status',$orderModel::STA_1)->sum('pay_money');
        $data['total_money'] = $orderModel->where('status',$orderModel::STA_1)->sum('pay_money');
        // 提现
        $data['recharge_day'] = $rechargeLogModel->whereBetween('created_at', $timeTool->day())->where('status',$rechargeLogModel::STA_1)->sum('pay_money');
        $data['recharge_total'] = $rechargeLogModel->where('status',$rechargeLogModel::STA_1)->sum('pay_money');
        // 流水
        $day_z = $moneyLogModel->where('change', '>', 0)->whereBetween('created_at', $timeTool->day())->sum('change');
        $day_f = $moneyLogModel->where('change', '<', 0)->whereBetween('created_at', $timeTool->day())->sum('change');
        $day_f = abs($day_f);
        $data['money_day'] = calc($day_z, '+', $day_f);
        $month_z = $moneyLogModel->where('change', '>', 0)->whereBetween('created_at', $timeTool->month())->sum('change');
        $month_f = $moneyLogModel->where('change', '<', 0)->whereBetween('created_at', $timeTool->month())->sum('change');
        $month_f = abs($month_f);
        $data['money_month'] = calc($month_z, '+', $month_f);
        $total_z = $moneyLogModel->where('change', '>', 0)->sum('change');
        $total_f = $moneyLogModel->where('change', '<', 0)->sum('change');
        $total_f = abs($total_f);
        $data['money_total'] = calc($total_z, '+', $total_f);

        return View::make('admin.admin.index.index', compact('data'));
    }

    /**
     * 用户数据
     *
     * @param  \App\ToolsClass\TimeTool      $timeTool
     * @param  \App\Services\User\UsersModel $usersModel
     */
    public function userData(TimeTool $timeTool, UsersModel $usersModel)
    {
        $dateData = $timeTool->days(14);
        $data = [];
        if ($dateData) {
            foreach ($dateData as $v) {
                $start = strtotime($v);
                $end = $start + 86400;
                $data[] = $usersModel->whereBetween('created_at', [$start, $end])->count();
            }
        }
        $data = [
            'title' => [
                'text' => '数据统计',
            ],
            'tooltip' => [
                'trigger' => 'axis',
            ],
            'legend' => [
                'data' => ['用户增长'],
            ],
            'grid' => [
                'left' => '3%',
                'right' => '4%',
                'bottom' => '3%',
                'containLabel' => true,
            ],
            'toolbox' => [
                'feature' => [
                    'saveAsImage' => [],
                ],
            ],
            'xAxis' => [
                'type' => 'category',
                'boundaryGap' => false,
                'data' => $dateData,
            ],
            'yAxis' => [
                'datypeta' => 'value',
            ],
            'series' => [[
                'name' => '用户增长',
                'type' => 'line',
                'areaStyle' => [],
                'data' => $data,
                'smooth' => true
            ]],
        ];
        return $this->success('请求成功', $data);
    }
}
