<?php

namespace App\Http\Controllers\Admin\Admin;

use App\Models\Admin\ConfigGroup;
use Illuminate\Support\Facades\DB;
use App\Models\Admin\Configuration;
use Illuminate\Support\Facades\View;
use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Response;
use App\Http\Requests\Admin\Admin\ConfigurationRequest;

class ConfigurationController extends BaseController
{
    /**
     * 配置主页
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $groups = ConfigGroup::with('configurations')->where('status', 1)->orderBy('sort', 'asc')->get();
        return View::make('admin.admin.configuration.index', compact('groups'));
    }

    /**
     * 添加配置
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        $groups = ConfigGroup::where('status', 1)->orderBy('sort', 'asc')->get();
        return View::make('admin.admin.configuration.create', compact('groups'));
    }

    /**
     * 添加配置
     *
     * @param  \App\Http\Requests\Admin\Admin\ConfigurationRequest $validate
     */
    public function store(ConfigurationRequest $validate)
    {
        $data = $this->request->all(['group_id', 'label', 'key', 'val', 'type', 'tips', 'sort']);
        if (!$validate->check($data)) {
            return $this->error($validate->getError());
        }
        try {
            Configuration::create($data);
        } catch (\Exception $exception) {
            return $this->error('添加失败');
        }
        return $this->success('添加成功!');
    }

    /**
     * 更新配置
     * @return \Illuminate\Http\JsonResponse
     */
    public function update(Configuration $config)
    {
        $data = $this->request->except(['_token', 'id']);
        DB::beginTransaction();
        try {
            foreach ($data as $k => $v) {
                $log = $config->where('key', $k)->first();
                if ($log) {
                    // 图片特殊处理
                    if ($log->type == 'image') {
                        $v = implode(',',$v);
                    }
                    $log->val = $v;
                    $log->save();
                }
            }
            DB::commit();
        } catch (\Exception $exception) {
            DB::rollback();
            return Response::json(['code' => 1, 'msg' => '更新失败']);
        }
        return Response::json(['code' => 0, 'msg' => '更新成功']);
    }
}
