<?php

namespace App\Exceptions;

use Exception;
use ErrorException;
use BadMethodCallException;
use Illuminate\Database\QueryException;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Predis\Connection\ConnectionException;
use Symfony\Component\HttpKernel\Exception\MethodNotAllowedHttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that are not reported.
     *
     * @var array
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var array
     */
    protected $dontFlash = [
        'password',
        'password_confirmation',
    ];

    /**
     * Report or log an exception.
     *
     * @param  \Exception  $exception
     * @return void
     *
     * @throws \Exception
     */
    public function report(Exception $exception)
    {
        parent::report($exception);
    }

    /**
     * Render an exception into an HTTP response.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Exception  $exception
     * @return \Symfony\Component\HttpFoundation\Response
     *
     * @throws \Exception
     */
    public function render($request, Exception $exception)
    {
        /** API 接口异常捕获 */
        if (strstr(request()->path(), 'api')) {
            if (env('APP_DEBUG') === false) {
                // 缓存服务器启动 Redis
                if ($exception instanceof ConnectionException) {
                    throw new ApiException('缓存服务启动失败', 500);
                }
                //请求路由找不到
                if ($exception instanceof NotFoundHttpException) {
                    throw new ApiException('请求页面错误!', 500);
                }
                // 请求方式报错处理
                if ($exception instanceof MethodNotAllowedHttpException) {
                    throw new ApiException('请求方式错误!', 500);
                }
                // 方法不存在报错处理
                if ($exception instanceof BadMethodCallException) {
                    throw new ApiException('方法不存在!', 500);
                }
                //数据库报错处理
                if ($exception instanceof QueryException) {
                    throw new ApiException('数据查询异常!', 500);
                }
                // 服务器错误
                if ($exception instanceof ErrorException) {
                    throw new ApiException('服务器错误!', 500);
                }
            }
        }
        return $this->handle($request, $exception);
    }

    // 新添加的handle函数
    public function handle($request, Exception $e)
    {
        return parent::render($request, $e);
    }
}
