<?php

namespace App\Exceptions;

use Exception;
use Throwable;

class ApiException extends Exception
{
    protected $message;

    protected $code;

    public function __construct($message = "缺少参数哦亲", $code = 400, Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);

        $this->code = $code;

        $this->message = $message;
    }

    public function render()
    {
        return response()->json(['code' => $this->code, 'msg' => $this->message, 'data' => []]);
    }
}
