<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        //
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        /** 幸运盲盒当天第一期 12:00 - 19:00 7个小时 */
        $schedule->command('task:luckbox_term 01 12 7')->dailyAt('12:00');
        /** 幸运盲盒当天第二期 19:00 - 12:00 17个小时 */
        $schedule->command('task:luckbox_term 02 19 17')->dailyAt('19:00');

        // /** 幸运盲盒当天第一期 */
        // $schedule->command('task:luckbox_term 01 09 1')->dailyAt('09:00');
        // $schedule->command('task:luckbox_term 02 10 1')->dailyAt('10:00');
        // $schedule->command('task:luckbox_term 03 11 1')->dailyAt('11:00');
        // $schedule->command('task:luckbox_term 04 12 1')->dailyAt('12:00');
        // $schedule->command('task:luckbox_term 05 13 1')->dailyAt('13:00');
        // $schedule->command('task:luckbox_term 06 14 1')->dailyAt('14:00');
        // $schedule->command('task:luckbox_term 07 15 1')->dailyAt('15:00');
        // $schedule->command('task:luckbox_term 08 16 1')->dailyAt('16:00');
        // $schedule->command('task:luckbox_term 09 17 1')->dailyAt('17:00');
        // $schedule->command('task:luckbox_term 10 18 1')->dailyAt('18:00');
        // $schedule->command('task:luckbox_term 11 19 1')->dailyAt('19:00');
        // $schedule->command('task:luckbox_term 12 20 1')->dailyAt('20:00');
        // $schedule->command('task:luckbox_term 13 21 1')->dailyAt('21:00');
        // $schedule->command('task:luckbox_term 14 22 11')->dailyAt('22:00');
        /** 未支付订单过期处理 */
        $schedule->command('task:order')->everyMinute()->withoutOverlapping();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
