<?php

namespace App\Console\Commands;

use App\Services\Order\OrderModel;
use Illuminate\Console\Command;

class Order extends Command
{
    protected $model;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'task:order';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = '订单过期处理';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->model = new OrderModel();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $this->model->expired();
        $this->info("任务执行成功..." . date('Y-m-d H:i:s'));
    }
}
