<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\Luckbox\TermModel;

class LuckboxTerm extends Command
{
    protected $model;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'task:luckbox_term{term}{clock}{hours}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = '幸运盲盒当天第一期';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->model = new TermModel();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $term = $this->argument('term');    // 当前第几期
        $clock = $this->argument('clock');  // 几点钟
        $hours = $this->argument('hours');  // 持续时长
        $this->info("Start...");
        $this->model->open($term, $clock, $hours);
        $this->info("End...");
    }
}
