<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/User.php';
require_once '../includes/EpayService.php';

// 验证通知签名
$epay = new EpayService();
if ($epay->verifyNotify($_GET) && $_GET['trade_status'] === 'TRADE_SUCCESS') {
    $orderNo = $_GET['out_trade_no'];
    $db = Database::getInstance();
    
    // 查询订单状态
    $order = $db->query("SELECT * FROM vip_orders WHERE order_no = ? LIMIT 1", [$orderNo])->fetch();
    
    if ($order && $order['status'] === 'paid') {
        // 支付成功，跳转到成功页面
        header('Location: /vip/success.php?order_no=' . $orderNo);
    } else {
        // 订单未支付，跳转到订单页面
        header('Location: /vip/?error=payment_pending');
    }
} else {
    // 验证失败，返回VIP页面
    header('Location: /vip/?error=verify_failed');
}
exit;