<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/User.php';

// 检查用户是否登录
if (!isset($_SESSION['user'])) {
    header('Location: /auth/wechat_login.php');
    exit;
}

$db = Database::getInstance();
$user = new User();

// 获取系统配置
$configs = $db->query("SELECT `key`, `value` FROM system_config WHERE `key` IN ('enable_vip_pay', 'enable_vip_card', 'card_purchase_url', 'card_purchase_description', 'card_purchase_contact')")->fetchAll(PDO::FETCH_KEY_PAIR);
$enableVipPay = $configs['enable_vip_pay'] ?? '1';
$enableVipCard = $configs['enable_vip_card'] ?? '1';
$cardPurchaseUrl = $configs['card_purchase_url'] ?? '';
$cardPurchaseDesc = $configs['card_purchase_description'] ?? '';
$cardPurchaseContact = $configs['card_purchase_contact'] ?? '';

// 获取VIP套餐列表
$plans = $db->query("SELECT * FROM vip_plans WHERE status = 'active' ORDER BY sort_order ASC")->fetchAll();

// 获取用户VIP信息
$vipExpireTime = $user->getVipExpireTime();

// 加载页头
require_once '../includes/header.php';
?>

<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <!-- VIP状态卡片 -->
            <div class="card shadow-sm mb-4">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <img src="<?php echo $_SESSION['user']['avatar']; ?>" class="rounded-circle" width="64" height="64" alt="头像">
                    </div>
                    <h5 class="card-title mb-3"><?php echo htmlspecialchars($_SESSION['user']['nickname']); ?></h5>
                    <?php if ($user->isVip()): ?>
                        <div class="text-success mb-2">
                            <i class="fas fa-crown"></i> VIP会员
                        </div>
                        <div class="small text-muted">
                            有效期至：<?php echo date('Y-m-d H:i', strtotime($vipExpireTime)); ?>
                        </div>
                    <?php else: ?>
                        <div class="text-muted mb-2">
                            <i class="fas fa-user"></i> 普通用户
                        </div>
                    <?php endif; ?>
                </div>
            </div>

           

            <?php if ($enableVipCard == '1'): ?>
            <!-- 卡密激活区域 -->
            <div class="card shadow-sm mb-4">
                <div class="card-body">
                    <h5 class="card-title text-center mb-4">
                        <i class="fas fa-ticket-alt text-primary"></i> 卡密激活
                    </h5>
                    <form id="cardForm" class="mb-3">
                        <div class="input-group">
                            <input type="text" class="form-control" name="card_no" placeholder="请输入VIP卡密" required>
                            <button class="btn btn-primary" type="submit">
                                <i class="fas fa-check-circle"></i> 立即激活
                            </button>
                        </div>
                    </form>
                    <?php if ($cardPurchaseUrl): ?>
                    <div class="text-center">
                        <a href="<?php echo htmlspecialchars($cardPurchaseUrl); ?>" class="btn btn-primary btn-lg px-5" target="_blank">
                            <i class="fas fa-shopping-cart me-2"></i>购买卡密
                        </a>
                    </div>
                    <?php if ($cardPurchaseDesc): ?>
                    <div class="alert alert-info mt-3">
                        <h6 class="mb-2"><i class="fas fa-info-circle me-2"></i>购买说明</h6>
                        <div class="small">
                            <?php echo nl2br(htmlspecialchars($cardPurchaseDesc)); ?>
                        </div>
                        <?php if ($cardPurchaseContact): ?>
                        <div class="mt-2">
                            <strong>联系方式：</strong><?php echo htmlspecialchars($cardPurchaseContact); ?>
                        </div>
                        <?php endif; ?>
                    </div>
                    

                    
                    <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
            
            <?php if ($enableVipPay == '1'): ?>
            <!-- VIP套餐列表 -->
            <div class="card shadow-sm">
                <div class="card-header bg-transparent border-0">
                    <h5 class="card-title text-center mb-0">
                        <i class="fas fa-crown text-warning"></i> VIP会员套餐
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row g-2">
                        <?php foreach ($plans as $plan): ?>
                        <div class="col-6">
                            <div class="vip-plan-card">
                                <input type="radio" name="vipPlan" 
                                       id="plan<?php echo $plan['id']; ?>" 
                                       value="<?php echo $plan['id']; ?>"
                                       class="vip-plan-input"
                                       <?php echo $plan === reset($plans) ? 'checked' : ''; ?>>
                                <label class="vip-plan-label" for="plan<?php echo $plan['id']; ?>">
                                    <div class="vip-plan-content">
                                        <div class="vip-plan-header">
                                            <h6 class="vip-plan-name"><?php echo htmlspecialchars($plan['name']); ?></h6>
                                            <span class="vip-plan-price">¥<?php echo number_format($plan['price'], 2); ?></span>
                                        </div>
                                        <div class="vip-plan-description"><?php echo htmlspecialchars($plan['description']); ?></div>
                                        <div class="vip-plan-check">
                                            <i class="fas fa-check-circle"></i>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="card-footer bg-transparent border-0 text-center">
                    <button type="button" class="btn btn-primary btn-lg px-5" onclick="createOrder()">
                        <i class="fas fa-shopping-cart me-2"></i>立即开通
                    </button>
                </div>
            </div>
            <?php endif; ?>
            
                                 <div class="alert alert-danger mb-4">
                        <i class="fas fa-exclamation-circle me-2"></i>
                        <strong>温馨提示：</strong>开通VIP后只能查看在本系统内生成动态后新产生的访客记录，无法查看开通前的历史访客记录。
                    </div>
                    
                    
                    <!-- <div class="text-center">-->
                    <!--    <a href="https://mh1.emc1.cn/5oiO" class="btn btn-primary btn-lg px-5" target="_blank">-->
                    <!--        <i class="fas fa-shopping-cart me-2"></i>不想付费？点我完成任务激活-->
                    <!--    </a>-->
                    <!--</div>-->
            
             <!-- VIP会员权益说明 -->
            <div class="card shadow-sm mb-4">
                <div class="card-body">
                    <h5 class="card-title text-center mb-4">
                        <i class="fas fa-crown text-warning"></i> VIP会员特权
                    </h5>
               
                    <div class="vip-benefits">
                        <div class="benefit-item">
                            <div class="benefit-icon">
                                <i class="fas fa-eye text-primary"></i>
                            </div>
                            <div class="benefit-content">
                                <h6>无限查看访客</h6>
                                <p>解锁所有访问记录，实时查看访问动态</p>
                            </div>
                        </div>
                        <div class="benefit-item">
                            <div class="benefit-icon">
                                <i class="fas fa-history text-success"></i>
                            </div>
                            <div class="benefit-content">
                                <h6>历史记录查询</h6>
                                <p>支持查看开通后的历史访问记录</p>
                            </div>
                        </div>
                        <div class="benefit-item">
                            <div class="benefit-icon">
                                <i class="fas fa-chart-line text-info"></i>
                            </div>
                            <div class="benefit-content">
                                <h6>访问统计分析</h6>
                                <p>查看访问趋势图表，了解访问规律</p>
                            </div>
                        </div>
                        <div class="benefit-item">
                            <div class="benefit-icon">
                                <i class="fas fa-bell text-warning"></i>
                            </div>
                            <div class="benefit-content">
                                <h6>实时访问提醒</h6>
                                <p>新访客立即通知，不错过重要来访</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            
        </div>
    </div>
</div>



<script>
// 创建订单
function createOrder() {
    const planId = document.querySelector('input[name="vipPlan"]:checked').value;
    
    fetch('/vip/create_order.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'plan_id=' + planId
    })
    .then(response => response.json())
    .then(data => {
        if (data.code === 0) {
            window.location.href = data.pay_url;
        } else {
            alert(data.msg);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('系统错误，请重试');
    });
}

// 卡密激活
document.getElementById('cardForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const cardNo = this.querySelector('input[name="card_no"]').value;
    
    fetch('/vip/activate_card.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'card_no=' + encodeURIComponent(cardNo)
    })
    .then(response => response.json())
    .then(data => {
        alert(data.msg);
        if (data.code === 0) {
            location.reload();
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('系统错误，请重试');
    });
});
</script>

<style>
.vip-plan-card {
    position: relative;
    height: 100%;
}

.vip-plan-input {
    position: absolute;
    opacity: 0;
    width: 0;
    height: 0;
}

.vip-plan-label {
    display: block;
    height: 100%;
    margin: 0;
    cursor: pointer;
}

.vip-plan-content {
    height: 100%;
    padding: 1rem;
    border: 2px solid #e9ecef;
    border-radius: 0.5rem;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
    display: flex;
    flex-direction: column;
}

.vip-plan-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 0.5rem;
    flex-wrap: wrap;
}

.vip-plan-name {
    margin: 0;
    font-size: 1rem;
    color: #333;
    margin-bottom: 0.3rem;
}

.vip-plan-price {
    font-size: 1rem;
    font-weight: 600;
    color: var(--bs-primary);
    background: rgba(var(--bs-primary-rgb), 0.1);
    padding: 0.25rem 0.5rem;
    border-radius: 2rem;
    margin-left: auto;
}

.vip-plan-description {
    color: #6c757d;
    font-size: 0.85rem;
    line-height: 1.4;
    flex-grow: 1;
    margin-bottom: 0.5rem;
}

.vip-plan-check {
    position: absolute;
    right: 0.5rem;
    bottom: 0.5rem;
    width: 24px;
    height: 24px;
    background: var(--bs-primary);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    transform: scale(0);
    transition: all 0.3s ease;
}

.vip-plan-check i {
    color: white;
    font-size: 1rem;
}

.vip-plan-input:checked + .vip-plan-label .vip-plan-content {
    border-color: var(--bs-primary);
    box-shadow: 0 0 0 1px var(--bs-primary);
    background: rgba(var(--bs-primary-rgb), 0.02);
}

.vip-plan-input:checked + .vip-plan-label .vip-plan-check {
    transform: scale(1);
    right: 0.5rem;
    bottom: 0.5rem;
}

.vip-plan-input:focus + .vip-plan-label .vip-plan-content {
    box-shadow: 0 0 0 2px rgba(var(--bs-primary-rgb), 0.25);
}

.vip-plan-content:hover {
    border-color: var(--bs-primary);
    transform: translateY(-2px);
}

@media (max-width: 576px) {
    .row.g-2 {
        margin: 0 -0.5rem;
    }
    
    .col-6 {
        padding: 0 0.5rem;
    }

    .vip-plan-content {
        padding: 0.75rem 0.75rem 1.25rem;
        min-height: 120px;
    }
    
    .vip-plan-header {
        flex-direction: column;
        align-items: flex-start;
        margin-bottom: 0.5rem;
    }
    
    .vip-plan-name {
        font-size: 0.9rem;
        margin-bottom: 0.3rem;
        padding-right: 0.5rem;
    }
    
    .vip-plan-price {
        font-size: 0.85rem;
        padding: 0.15rem 0.4rem;
        margin-left: 0;
        margin-bottom: 0.4rem;
    }
    
    .vip-plan-description {
        font-size: 0.75rem;
        line-height: 1.3;
        margin-bottom: 1rem;
    }
    
    .vip-plan-check {
        width: 20px;
        height: 20px;
        right: 0.5rem;
        bottom: 0.5rem;
    }
    
    .vip-plan-check i {
        font-size: 0.7rem;
    }

    .vip-plan-input:checked + .vip-plan-label .vip-plan-check {
        transform: scale(1);
        right: 0.5rem;
        bottom: 0.5rem;
    }
}

/* VIP会员权益样式 */
.vip-benefits {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 1.5rem;
}

.benefit-item {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
}

.benefit-icon {
    width: 40px;
    height: 40px;
    background: rgba(var(--bs-primary-rgb), 0.1);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.benefit-icon i {
    font-size: 1.2rem;
}

.benefit-content h6 {
    margin: 0 0 0.3rem;
    font-size: 0.95rem;
    color: #333;
}

.benefit-content p {
    margin: 0;
    font-size: 0.8rem;
    color: #666;
    line-height: 1.4;
}

@media (max-width: 576px) {
    .vip-benefits {
        grid-template-columns: 1fr;
        gap: 1rem;
    }

    .benefit-icon {
        width: 32px;
        height: 32px;
    }

    .benefit-icon i {
        font-size: 1rem;
    }

    .benefit-content h6 {
        font-size: 0.9rem;
    }

    .benefit-content p {
        font-size: 0.75rem;
    }
}
</style>

<?php require_once '../includes/footer.php'; ?> 