<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/User.php';
require_once '../includes/EpayService.php';

// 检查用户是否登录
if (!isset($_SESSION['user'])) {
    die(json_encode(['code' => 1, 'msg' => '请先登录']));
}

// 获取套餐ID
$planId = $_POST['plan_id'] ?? 0;
if (!$planId) {
    die(json_encode(['code' => 1, 'msg' => '请选择套餐']));
}

try {
    $db = Database::getInstance();
    
    // 获取套餐信息
    $plan = $db->query("SELECT * FROM vip_plans WHERE id = ? AND status = 'active'", [$planId])->fetch();
    if (!$plan) {
        die(json_encode(['code' => 1, 'msg' => '套餐不存在或已下架']));
    }
    
    // 创建订单号
    $orderNo = date('YmdHis') . mt_rand(1000, 9999);
    
    // 创建订单记录
    $db->query("INSERT INTO vip_orders (user_id, order_no, amount, days, status) VALUES (?, ?, ?, ?, 'pending')",
        [$_SESSION['user']['id'], $orderNo, $plan['price'], $plan['days']]);
    
    // 创建支付链接
    $epay = new EpayService();
    $payUrl = $epay->createOrder($orderNo, $plan['price'], $plan['name']);
    
    echo json_encode(['code' => 0, 'msg' => 'success', 'pay_url' => $payUrl]);
} catch (Exception $e) {
    echo json_encode(['code' => 1, 'msg' => '系统错误，请重试']);
} 