<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/Post.php';
require_once '../includes/WechatShare.php';

// 获取分享码
$shareCode = isset($_GET['code']) ? $_GET['code'] : '';

// 获取动态详情
$post = new Post();
$postData = $post->getPostByShareCode($shareCode);

// 如果动态不存在，重定向到首页
if (!$postData) {
    header('Location: /');
    exit;
}

// 如果用户未登录，保存当前URL并重定向到登录页面
if (!isset($_SESSION['user'])) {
    $_SESSION['redirect_url'] = $_SERVER['REQUEST_URI'];
    header('Location: /auth/wechat_login.php');
    exit;
}

// 记录访问
$post->recordVisit($postData['id'], $_SESSION['user']['id']);

// 配置微信分享
$wechatShare = new WechatShare();
$currentUrl = "https://{$_SERVER['HTTP_HOST']}{$_SERVER['REQUEST_URI']}";
$shareConfig = $wechatShare->getJsConfig($currentUrl);

// 设置页面标题
$pageTitle = mb_substr($postData['content'], 0, 20) . '...';

require_once '../includes/header.php';
?>

<style>
.image-grid {
    display: grid;
    gap: 6px;
    margin-bottom: 16px;
}

.image-grid.grid-1 {
    grid-template-columns: 1fr;
}

.image-grid.grid-2,
.image-grid.grid-3,
.image-grid.grid-4 {
    grid-template-columns: repeat(2, 1fr);
}

.image-grid.grid-5,
.image-grid.grid-6,
.image-grid.grid-7,
.image-grid.grid-8,
.image-grid.grid-9 {
    grid-template-columns: repeat(3, 1fr);
}

.image-item {
    position: relative;
    padding-bottom: 100%;
    background: #f5f5f5;
    border-radius: 8px;
    overflow: hidden;
}

.image-item img {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.image-grid.grid-1 .image-item {
    padding-bottom: 56.25%; /* 16:9 比例 */
}
</style>

<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <img src="<?php echo htmlspecialchars($postData['avatar']); ?>" 
                             class="rounded-circle me-2" 
                             width="40" height="40" 
                             alt="<?php echo htmlspecialchars($postData['nickname']); ?>">
                        <div>
                            <h6 class="mb-0"><?php echo htmlspecialchars($postData['nickname']); ?></h6>
                            <small class="text-muted">
                                <?php echo date('Y-m-d H:i', strtotime($postData['created_at'])); ?>
                            </small>
                        </div>
                    </div>

                    <div class="post-content mb-3">
                        <?php echo nl2br(htmlspecialchars($postData['content'])); ?>
                    </div>

                    <?php if ($postData['image']): ?>
                    <?php 
                    $images = explode('|', $postData['image']);
                    $imageCount = count($images);
                    if ($imageCount > 0):
                    ?>
                    <div class="image-grid grid-<?php echo $imageCount; ?>">
                        <?php foreach ($images as $image): ?>
                        <div class="image-item">
                            <img src="<?php echo htmlspecialchars($image); ?>" 
                                 class="img-fluid" 
                                 alt="动态图片"
                                 onclick="showFullImage('<?php echo htmlspecialchars($image); ?>')">
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <?php endif; ?>
                    <?php endif; ?>

                    <div class="d-flex justify-content-between align-items-center text-muted small">
                        <div>
                            <i class="fas fa-eye me-1"></i> <?php echo number_format($postData['view_count']); ?> 次浏览
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- 图片预览模态框 -->
<div class="modal fade" id="imageModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-body p-0">
                <img src="" id="modalImage" class="img-fluid w-100">
            </div>
        </div>
    </div>
</div>

<!-- 微信JS SDK -->
<script src="https://res.wx.qq.com/open/js/jweixin-1.6.0.js"></script>
<script>
// 准备分享图片
var shareImgUrl = '<?php 
    if (!empty($postData["image"])) {
        // 如果动态有图片，使用第一张图片
        $images = explode('|', $postData["image"]);
        echo "https://{$_SERVER['HTTP_HOST']}" . $images[0];
    } else {
        // 否则使用默认分享图片
        echo "https://{$_SERVER['HTTP_HOST']}/assets/images/share-logo.png";
    }
?>';

wx.config({
    debug: false,
    appId: '<?php echo $shareConfig["appId"]; ?>',
    timestamp: <?php echo $shareConfig["timestamp"]; ?>,
    nonceStr: '<?php echo $shareConfig["nonceStr"]; ?>',
    signature: '<?php echo $shareConfig["signature"]; ?>',
    jsApiList: [
        'updateAppMessageShareData',
        'updateTimelineShareData',
        'onMenuShareTimeline',
        'onMenuShareAppMessage'
    ]
});

wx.ready(function() {
    // 分享给朋友
    wx.updateAppMessageShareData({ 
        title: '<?php echo htmlspecialchars($postData['nickname']); ?>的动态', 
        desc: '<?php echo htmlspecialchars(mb_substr($postData['content'], 0, 50)); ?>...',
        link: '<?php echo $currentUrl; ?>', 
        imgUrl: shareImgUrl,
        success: function () {
            // 设置成功
        }
    });
    
    // 分享到朋友圈
    wx.updateTimelineShareData({ 
        title: '<?php echo htmlspecialchars($postData['nickname']); ?>的动态 - <?php echo htmlspecialchars(mb_substr($postData['content'], 0, 30)); ?>...', 
        link: '<?php echo $currentUrl; ?>', 
        imgUrl: shareImgUrl,
        success: function () {
            // 设置成功
        }
    });
});

// 图片预览功能
function showFullImage(src) {
    const modal = new bootstrap.Modal(document.getElementById('imageModal'));
    document.getElementById('modalImage').src = src;
    modal.show();
}
</script>

<?php require_once '../includes/footer.php'; ?> 