<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once '../config/config.php';
require_once '../includes/Database.php';
require_once '../includes/Post.php';

// 检查用户是否登录
if (!isset($_SESSION['user'])) {
    header('Location: /auth/wechat_login.php');
    exit;
}

// 处理表单提交
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $content = $_POST['content'];
    $images = [];
    
    // 处理多图上传
    if (isset($_FILES['images'])) {
        foreach ($_FILES['images']['tmp_name'] as $key => $tmp_name) {
            if ($_FILES['images']['error'][$key] === UPLOAD_ERR_OK) {
                $ext = pathinfo($_FILES['images']['name'][$key], PATHINFO_EXTENSION);
                $filename = uniqid() . '.' . $ext;
                $uploadPath = UPLOAD_PATH . $filename;
                
                if (move_uploaded_file($tmp_name, $uploadPath)) {
                    $images[] = '/uploads/' . $filename;
                }
            }
        }
    }
    
    // 创建动态
    $post = new Post();
    $postId = $post->create($_SESSION['user']['id'], $content, implode('|', $images));
    
    if ($postId) {
        // 跳转到动态详情页
        header('Location: /posts/view.php?id=' . $postId);
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>发表动态 - 朋友圈访客查询系统</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css" rel="stylesheet">
    <link href="/assets/css/style.css" rel="stylesheet">
    <style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }
    
    body {
        background: #fff;
        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
        line-height: 1.6;
        color: #333;
    }

    .post-editor {
        min-height: 100vh;
        display: flex;
        flex-direction: column;
    }

    .post-header {
        padding: 12px 16px;
        border-bottom: 1px solid #eee;
        display: flex;
        justify-content: space-between;
        align-items: center;
        position: sticky;
        top: 0;
        background: #fff;
        z-index: 100;
    }

    .post-header .btn-cancel {
        color: #333;
        text-decoration: none;
        font-size: 16px;
        padding: 0;
        background: none;
        border: none;
    }

    .post-header h1 {
        font-size: 17px;
        margin: 0;
        font-weight: normal;
        color: #333;
    }

    .post-content {
        flex: 1;
        padding: 16px;
        background: #fff;
    }

    .post-textarea {
        width: 100%;
        min-height: 120px;
        border: none;
        resize: none;
        font-size: 16px;
        line-height: 1.6;
        padding: 0;
        margin-bottom: 16px;
    }

    .post-textarea:focus {
        outline: none;
        box-shadow: none;
    }

    .post-textarea::placeholder {
        color: #999;
    }

    .image-grid {
        display: grid;
        gap: 6px;
        margin-bottom: 16px;
    }

    .image-grid.grid-1 {
        grid-template-columns: 1fr;
    }

    .image-grid.grid-2,
    .image-grid.grid-3,
    .image-grid.grid-4 {
        grid-template-columns: repeat(2, 1fr);
    }

    .image-grid.grid-5,
    .image-grid.grid-6,
    .image-grid.grid-7,
    .image-grid.grid-8,
    .image-grid.grid-9 {
        grid-template-columns: repeat(3, 1fr);
    }

    .image-item {
        position: relative;
        padding-bottom: 100%;
        background: #f5f5f5;
        border-radius: 8px;
        overflow: hidden;
    }

    .image-item img {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .image-item .remove-image {
        position: absolute;
        top: 4px;
        right: 4px;
        background: rgba(0,0,0,0.6);
        color: #fff;
        border-radius: 50%;
        width: 22px;
        height: 22px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        font-size: 14px;
        z-index: 1;
    }

    .image-upload {
        position: relative;
        padding-bottom: 100%;
        background: #f8f9fa;
        border-radius: 8px;
        cursor: pointer;
        border: 1px dashed #ddd;
    }

    .image-upload-icon {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        color: #576b95;
        font-size: 24px;
    }

    .post-toolbar {
        padding: 12px 16px;
        border-top: 1px solid #eee;
        display: flex;
        align-items: center;
        background: #f8f9fa;
    }

    .post-submit {
        margin-left: auto;
        background: #07C160;
        color: white;
        border: none;
        padding: 8px 24px;
        border-radius: 4px;
        font-size: 16px;
        font-weight: 500;
    }

    .post-submit:disabled {
        background: #9ED99E;
        cursor: not-allowed;
    }

    .character-count {
        color: #999;
        margin-right: 16px;
        font-size: 14px;
    }
    </style>
</head>
<body>
    <div class="post-editor">
        <!-- 教程弹窗 -->
        <div class="modal fade" id="tutorialModal" data-bs-backdrop="static" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><i class="fas fa-graduation-cap text-primary"></i> 使用教程</h5>
                    </div>
                    <div class="modal-body">
                        <div class="text-center mb-4">
                            <i class="fas fa-book-reader text-primary" style="font-size: 48px;"></i>
                            <h4 class="mt-3">如何使用本系统？</h4>
                            <p class="text-muted">请选择您喜欢的学习方式</p>
                        </div>
                        <div class="d-grid gap-2">
                            <button type="button" class="btn btn-primary" onclick="showTutorial()">
                                <i class="fas fa-book-open me-2"></i>查看图文教程
                            </button>
                            <a href="https://alimov2.a.yximgs.com/upic/2024/12/22/19/BMjAyNDEyMjIxOTA4MTlfMzA1NjIxMzA0Nl8xNTE4NzI0MzA3NjFfMV8z_b_Be440299f21c52493d1605a762a5b1e1e.mp4?tag=1-1734865735-sr-0-5967be10b83044ab-3d4b358efb604372&clientCacheKey=3xmp783adh838nm_b.mp4&tt=b&di=8bc7ba36&bp=10001" target="_blank" class="btn btn-danger">
                                <i class="fas fa-play-circle me-2"></i>观看视频教程
                            </a>
                            <button type="button" class="btn btn-secondary" onclick="skipTutorial()">
                                <i class="fas fa-check me-2"></i>我已了解使用方法
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- 详细教程弹窗 -->
        <div class="modal fade" id="detailTutorialModal" data-bs-backdrop="static" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><i class="fas fa-book-open text-primary"></i> 图文使用教程</h5>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-info mb-4">
                            <i class="fas fa-video me-2"></i>
                            <strong>提示：</strong>
                            如果您更喜欢视频教程，可以
                            <a href="https://alimov2.a.yximgs.com/upic/2024/12/22/19/BMjAyNDEyMjIxOTA4MTlfMzA1NjIxMzA0Nl8xNTE4NzI0MzA3NjFfMV8z_b_Be440299f21c52493d1605a762a5b1e1e.mp4?tag=1-1734865735-sr-0-5967be10b83044ab-3d4b358efb604372&clientCacheKey=3xmp783adh838nm_b.mp4&tt=b&di=8bc7ba36&bp=10001" target="_blank" class="alert-link">点击这里观看视频教程</a>
                        </div>
                        <div class="tutorial-steps">
                            <div class="step mb-4">
                                <h5 class="d-flex align-items-center">
                                    <span class="badge bg-primary rounded-circle me-2">1</span>
                                    发布动态
                                </h5>
                                <div class="ps-4">
                                    <p>在文本框中输入您想说的话，可以：</p>
                                    <ul>
                                        <li>添加文字内容</li>
                                        <li>上传图片（最多9张）</li>
                                        <li>编辑完成后点击"发表"按钮</li>
                                    </ul>
                                </div>
                            </div>
                            
                            <div class="step mb-4">
                                <h5 class="d-flex align-items-center">
                                    <span class="badge bg-danger rounded-circle me-2">2</span>
                                    分享到朋友圈（重要）
                                </h5>
                                <div class="ps-4">
                                    <p class="text-danger"><strong>这是最关键的一步！</strong></p>
                                    <ul>
                                        <li>发布后会自动跳转到动态详情页</li>
                                        <li>点击"分享到朋友圈"按钮</li>
                                        <li>完成微信分享操作</li>
                                    </ul>
                                    <div class="alert alert-warning">
                                        <i class="fas fa-exclamation-triangle me-2"></i>
                                        <strong>注意：</strong>必须完成分享，否则无法追踪访客！
                                    </div>
                                </div>
                            </div>
                            
                            <div class="step mb-4">
                                <h5 class="d-flex align-items-center">
                                    <span class="badge bg-success rounded-circle me-2">3</span>
                                    等待访客查看
                                </h5>
                                <div class="ps-4">
                                    <p>当朋友查看您分享的动态时：</p>
                                    <ul>
                                        <li>系统会自动记录访客信息</li>
                                        <li>包括访问时间、设备信息等</li>
                                        <li>对方无需登录即可被记录</li>
                                    </ul>
                                </div>
                            </div>
                            
                            <div class="step">
                                <h5 class="d-flex align-items-center">
                                    <span class="badge bg-info rounded-circle me-2">4</span>
                                    查看访客记录
                                </h5>
                                <div class="ps-4">
                                    <p>您可以随时查看访客记录：</p>
                                    <ul>
                                        <li>在动态详情页直接查看</li>
                                        <li>可以看到访客的基本信息</li>
                                        <li>支持查看历史访问记录</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <a href="https://alimov2.a.yximgs.com/upic/2024/12/22/19/BMjAyNDEyMjIxOTA4MTlfMzA1NjIxMzA0Nl8xNTE4NzI0MzA3NjFfMV8z_b_Be440299f21c52493d1605a762a5b1e1e.mp4?tag=1-1734865735-sr-0-5967be10b83044ab-3d4b358efb604372&clientCacheKey=3xmp783adh838nm_b.mp4&tt=b&di=8bc7ba36&bp=10001" target="_blank" class="btn btn-danger me-2">
                            <i class="fas fa-play-circle me-2"></i>观看视频教程
                        </a>
                        <button type="button" class="btn btn-primary" onclick="startUsing()">
                            <i class="fas fa-check me-2"></i>我明白了，开始使用
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <form method="POST" enctype="multipart/form-data" id="postForm">
            <div class="post-header">
                <button type="button" class="btn-cancel" onclick="history.back()">取消</button>
                <h1>发表动态</h1>
                <button type="submit" class="post-submit" id="submitBtn" disabled>发表</button>
            </div>
            
            <!-- 添加提示卡片 -->
            <div class="alert alert-warning m-3">
                <h5 class="alert-heading"><i class="fas fa-info-circle"></i> 重要提示</h5>
                <p class="mb-0">发布动态后，<strong class="text-danger">必须点击"分享到朋友圈"按钮并完成分享</strong>，才能追踪查看访客记录。</p>
                <hr>
                <ol class="mb-0">
                    <li>发布动态</li>
                    <li><strong class="text-danger">分享到朋友圈（必须）</strong></li>
                    <li>等待朋友访问</li>
                    <li>查看访客记录</li>
                </ol>
            </div>
            
            <div class="post-content">
                <textarea class="post-textarea" 
                          name="content" 
                          id="content" 
                          placeholder="这一刻的想法..."
                          maxlength="1000"
                          autofocus></textarea>
                
                <div id="imageGrid" class="image-grid">
                    <!-- 图片预览将在这里动态生成 -->
                </div>
            </div>
            
            <div class="post-toolbar">
                <label class="image-upload" for="images" style="width: 40px; height: 40px; padding: 0; margin: 0;">
                    <i class="fas fa-image image-upload-icon" style="position: static; transform: none;"></i>
                </label>
                <input type="file" 
                       id="images" 
                       name="images[]" 
                       accept="image/*" 
                       multiple
                       style="display:none;"
                       onchange="handleImageSelect(this)">
                
                <span class="character-count">0/1000</span>
            </div>
        </form>
    </div>

    <!-- Bootstrap 5 JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
    let selectedImages = [];

    document.addEventListener('DOMContentLoaded', function() {
        const textarea = document.getElementById('content');
        const submitBtn = document.getElementById('submitBtn');
        const charCount = document.querySelector('.character-count');
        
        // 自动聚焦到输入框
        textarea.focus();
        
        textarea.addEventListener('input', function() {
            const length = this.value.length;
            charCount.textContent = length + '/1000';
            updateSubmitButton();
        });

        // 每次进入页面都显示教程弹窗
        const tutorialModal = new bootstrap.Modal(document.getElementById('tutorialModal'));
        tutorialModal.show();
    });

    function handleImageSelect(input) {
        const files = Array.from(input.files);
        if (selectedImages.length + files.length > 9) {
            alert('最多只能上传9张图片');
            return;
        }
        
        files.forEach(file => {
            const reader = new FileReader();
            reader.onload = function(e) {
                selectedImages.push(e.target.result);
                updateImageGrid();
            }
            reader.readAsDataURL(file);
        });
    }

    function removeImage(index) {
        selectedImages.splice(index, 1);
        updateImageGrid();
        
        // 清除文件输入框的值，允许重新选择同一文件
        document.getElementById('images').value = '';
    }

    function updateImageGrid() {
        const grid = document.getElementById('imageGrid');
        grid.className = 'image-grid grid-' + selectedImages.length;
        
        let html = selectedImages.map((src, index) => `
            <div class="image-item">
                <img src="${src}" alt="预览图片">
                <span class="remove-image" onclick="removeImage(${index})">&times;</span>
            </div>
        `).join('');
        
        // 如果图片数量少于9，添加上传按钮
        if (selectedImages.length < 9) {
            html += `
                <label class="image-upload" for="images">
                    <i class="fas fa-plus image-upload-icon"></i>
                </label>
            `;
        }
        
        grid.innerHTML = html;
        updateSubmitButton();
    }

    function updateSubmitButton() {
        const content = document.getElementById('content').value;
        const submitBtn = document.getElementById('submitBtn');
        submitBtn.disabled = content.length === 0 && selectedImages.length === 0;
    }

    function showTutorial() {
        // 隐藏第一个弹窗
        const tutorialModal = bootstrap.Modal.getInstance(document.getElementById('tutorialModal'));
        tutorialModal.hide();
        
        // 显示详细教程弹窗
        const detailTutorialModal = new bootstrap.Modal(document.getElementById('detailTutorialModal'));
        detailTutorialModal.show();
    }

    function skipTutorial() {
        // 直接关闭弹窗
        const tutorialModal = bootstrap.Modal.getInstance(document.getElementById('tutorialModal'));
        tutorialModal.hide();
    }

    function startUsing() {
        // 直接关闭详细教程弹窗
        const detailTutorialModal = bootstrap.Modal.getInstance(document.getElementById('detailTutorialModal'));
        detailTutorialModal.hide();
    }
    </script>
</body>
</html> 