<?php
/**
 * 朋友圈访客查询系统 - 首页
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

require_once 'config/config.php';

// 如果用户已登录，跳转到首页
if (isset($_SESSION['user'])) {
    header('Location: /posts/index.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>登录 - 朋友圈访客查询系统</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link href="/assets/css/style.css" rel="stylesheet">
</head>
<body class="login-page">
    <div class="login-box">
        <div class="logo">
            <i class="fas fa-eye"></i>
            <h1 class="h3 mt-3">朋友圈访客查询系统</h1>
            <p class="text-muted">发现谁偷偷关注了你</p>
        </div>
        
        <div class="text-center">
            <a href="/auth/wechat_login.php" class="btn btn-primary btn-lg w-100">
                <i class="fab fa-weixin me-2"></i>微信一键登录
            </a>
            
            <div class="mt-4">
                <p class="text-muted small">
                    登录即表示您同意我们的
                    <a href="/terms.php" class="text-decoration-none">服务条款</a>
                    和
                    <a href="/privacy.php" class="text-decoration-none">隐私政策</a>
                </p>
            </div>
        </div>

        <!-- 功能介绍 -->
        <div class="mt-5">
            <h5 class="text-center mb-4">使用步骤</h5>
            <div class="row g-3">
                <div class="col-12">
                    <div class="card border-primary">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <span class="badge bg-primary rounded-circle me-3">1</span>
                                <div>
                                    <h6 class="mb-1">发布动态</h6>
                                    <p class="mb-0 small text-muted">发布一条包含文字或图片的动态</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="card border-primary">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <span class="badge bg-primary rounded-circle me-3">2</span>
                                <div>
                                    <h6 class="mb-1">分享到朋友圈 <span class="badge bg-danger">重要</span></h6>
                                    <p class="mb-0 small text-muted">必须分享到朋友圈才能追踪访客，发布后不分享将无法查看访客</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="card border-primary">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <span class="badge bg-primary rounded-circle me-3">3</span>
                                <div>
                                    <h6 class="mb-1">查看访客</h6>
                                    <p class="mb-0 small text-muted">实时查看谁浏览了你分享的动态</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap 5 JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html> 