<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? $pageTitle . ' - ' : ''; ?></title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link href="/assets/css/style.css" rel="stylesheet">
</head>
<body class="bg-light">
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="/">
                <i class="fas fa-eye me-2"></i>迅软访客
            </a>
            <?php if (isset($_SESSION['user'])): ?>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <?php if (isset($_SESSION['user'])): ?>
                    <li class="nav-item me-2">
                        <a class="nav-link" href="/feedback/create.php">
                            <i class="fas fa-comment-dots me-1"></i>提交反馈
                        </a>
                    </li>
                    <li class="nav-item me-2">
                        <a class="nav-link" href="/faq">
                            <i class="fas fa-question-circle me-1"></i>常见问题
                        </a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                            <img src="<?php echo htmlspecialchars($_SESSION['user']['avatar']); ?>" 
                                 class="rounded-circle me-1" 
                                 width="24" height="24" 
                                 alt="<?php echo htmlspecialchars($_SESSION['user']['nickname']); ?>">
                            <?php echo htmlspecialchars($_SESSION['user']['nickname']); ?>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li>
                                <a class="dropdown-item" href="/user/profile.php">
                                    <i class="fas fa-user me-2"></i>个人资料
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="/posts/index.php">
                                    <i class="fas fa-list me-2"></i>我的动态
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="/feedback/list.php">
                                    <i class="fas fa-comments me-2"></i>我的反馈
                                </a>
                            </li>
                            <?php if (isset($_SESSION['user']['role']) && $_SESSION['user']['role'] === 'admin'): ?>
                            <li>
                                <a class="dropdown-item" href="/admin/index.php">
                                    <i class="fas fa-cog me-2"></i>后台管理
                                </a>
                            </li>
                            <?php endif; ?>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <a class="dropdown-item" href="/auth/logout.php">
                                    <i class="fas fa-sign-out-alt me-2"></i>退出登录
                                </a>
                            </li>
                        </ul>
                    </li>
                    <?php else: ?>
                    <li class="nav-item">
                        <a class="nav-link" href="/auth/wechat_login.php">
                            <i class="fab fa-weixin me-1"></i>微信登录
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
            <?php endif; ?>
        </div>
    </nav>
    <main class="container my-4"> 