<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

class FAQ {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance();
    }

    // 创建新的FAQ
    public function create($data) {
        $sql = "INSERT INTO faq (question, answer, category, sort_order, status, images) VALUES (?, ?, ?, ?, ?, ?)";
        return $this->db->query($sql, [
            $data['question'],
            $data['answer'],
            $data['category'],
            $data['sort_order'] ?? 0,
            $data['status'] ?? 1,
            $data['images'] ?? null
        ]);
    }

    // 更新FAQ
    public function update($id, $data) {
        $sql = "UPDATE faq SET question = ?, answer = ?, category = ?, sort_order = ?, status = ?, images = ? WHERE id = ?";
        return $this->db->query($sql, [
            $data['question'],
            $data['answer'],
            $data['category'],
            $data['sort_order'],
            $data['status'],
            $data['images'],
            $id
        ])->rowCount() > 0;
    }

    // 删除FAQ
    public function delete($id) {
        // 获取FAQ信息以删除图片
        $faq = $this->get($id);
        if ($faq && $faq['images']) {
            $images = explode('|', $faq['images']);
            foreach ($images as $image) {
                if (file_exists(UPLOAD_PATH . basename($image))) {
                    unlink(UPLOAD_PATH . basename($image));
                }
            }
        }
        
        $sql = "DELETE FROM faq WHERE id = ?";
        return $this->db->query($sql, [$id])->rowCount() > 0;
    }

    // 获取单个FAQ
    public function get($id) {
        $sql = "SELECT * FROM faq WHERE id = ?";
        return $this->db->query($sql, [$id])->fetch(PDO::FETCH_ASSOC);
    }

    // 获取所有FAQ（后台使用）
    public function getAll($page = 1, $limit = 10) {
        $offset = ($page - 1) * $limit;
        $sql = "SELECT * FROM faq ORDER BY sort_order ASC, id DESC LIMIT ? OFFSET ?";
        return $this->db->query($sql, [$limit, $offset])->fetchAll(PDO::FETCH_ASSOC);
    }

    // 获取前台显示的FAQ
    public function getPublicFAQs() {
        $sql = "SELECT * FROM faq WHERE status = 1 ORDER BY sort_order ASC, id DESC";
        return $this->db->query($sql)->fetchAll(PDO::FETCH_ASSOC);
    }

    // 按分类获取FAQ
    public function getFAQsByCategory($category) {
        $sql = "SELECT * FROM faq WHERE status = 1 AND category = ? ORDER BY sort_order ASC, id DESC";
        return $this->db->query($sql, [$category])->fetchAll(PDO::FETCH_ASSOC);
    }

    // 获取所有分类
    public function getCategories() {
        $sql = "SELECT DISTINCT category FROM faq WHERE status = 1 ORDER BY category ASC";
        return $this->db->query($sql)->fetchAll(PDO::FETCH_COLUMN);
    }

    // 获取总数
    public function getTotal() {
        $sql = "SELECT COUNT(*) FROM faq";
        return $this->db->query($sql)->fetchColumn();
    }
} 