<?php
/**
 * 朋友圈访客查询系统
 * 
 * @author    锅岛主
 * @link      https://ggdao.net
 * @wechat    IJG55555
 * @copyright Copyright (c) 2026 锅岛主 (https://ggdao.net)
 * @license   保留所有权利
 */

class Cache {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    // 获取缓存
    public function get($key) {
        $result = $this->db->query(
            "SELECT value FROM cache WHERE `key` = ? AND expire_time > ?", 
            [$key, time()]
        )->fetch();
        
        return $result ? $result['value'] : false;
    }
    
    // 设置缓存
    public function set($key, $value, $ttl = 3600) {
        $expireTime = time() + $ttl;
        
        try {
            $this->db->query(
                "REPLACE INTO cache (`key`, value, expire_time) VALUES (?, ?, ?)",
                [$key, $value, $expireTime]
            );
            return true;
        } catch (Exception $e) {
            return false;
        }
    }
    
    // 删除缓存
    public function delete($key) {
        try {
            $this->db->query("DELETE FROM cache WHERE `key` = ?", [$key]);
            return true;
        } catch (Exception $e) {
            return false;
        }
    }
    
    // 清理过期缓存
    public function clean() {
        try {
            $this->db->query("DELETE FROM cache WHERE expire_time <= ?", [time()]);
            return true;
        } catch (Exception $e) {
            return false;
        }
    }
} 